/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.txstate.RelationshipChangeVisitorAdapter;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.cursor.TxAllPropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleNodeCursor;
import org.neo4j.kernel.impl.api.cursor.TxSinglePropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleRelationshipCursor;
import org.neo4j.kernel.impl.api.state.GraphState;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.PropertyChanges;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.RelationshipDiffSets;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.DiffSetsVisitor;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableRelationshipDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public final class TxState
implements TransactionState,
RelationshipVisitor.Home {
    private Map<Integer, LabelState.Mutable> labelStatesMap;
    private static final LabelState.Defaults LABEL_STATE = new LabelState.Defaults(){

        @Override
        Map<Integer, LabelState.Mutable> getMap(TxState state) {
            return state.labelStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Integer, LabelState.Mutable> map) {
            state.labelStatesMap = map;
        }
    };
    private Map<Long, NodeStateImpl> nodeStatesMap;
    private static final NodeStateImpl.Defaults NODE_STATE = new NodeStateImpl.Defaults(){

        @Override
        Map<Long, NodeStateImpl> getMap(TxState state) {
            return state.nodeStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Long, NodeStateImpl> map) {
            state.nodeStatesMap = map;
        }
    };
    private Map<Long, RelationshipStateImpl> relationshipStatesMap;
    private static final RelationshipStateImpl.Defaults RELATIONSHIP_STATE = new RelationshipStateImpl.Defaults(){

        @Override
        Map<Long, RelationshipStateImpl> getMap(TxState state) {
            return state.relationshipStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Long, RelationshipStateImpl> map) {
            state.relationshipStatesMap = map;
        }
    };
    private Map<Integer, String> createdLabelTokens;
    private Map<Integer, String> createdPropertyKeyTokens;
    private Map<Integer, String> createdRelationshipTypeTokens;
    private GraphState graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<ConstraintDescriptor> constraintsChanges;
    private PropertyChanges propertyChangesForNodes;
    private DiffSets<Long> nodes;
    private RelationshipDiffSets<Long> relationships;
    private PrimitiveLongSet nodesDeletedInTx;
    private PrimitiveLongSet relationshipsDeletedInTx;
    private Map<IndexBackedConstraintDescriptor, Long> createdConstraintIndexesByConstraint;
    private Map<LabelSchemaDescriptor, Map<ValueTuple, DiffSets<Long>>> indexUpdates;
    private InstanceCache<TxSingleNodeCursor> singleNodeCursor = new InstanceCache<TxSingleNodeCursor>(){

        @Override
        protected TxSingleNodeCursor create() {
            return new TxSingleNodeCursor(TxState.this, this);
        }
    };
    private InstanceCache<TxIteratorRelationshipCursor> iteratorRelationshipCursor;
    private InstanceCache<TxSingleRelationshipCursor> singleRelationshipCursor;
    private InstanceCache<TxAllPropertyCursor> propertyCursor = new InstanceCache<TxAllPropertyCursor>(){

        @Override
        protected TxAllPropertyCursor create() {
            return new TxAllPropertyCursor(this);
        }
    };
    private InstanceCache<TxSinglePropertyCursor> singlePropertyCursor = new InstanceCache<TxSinglePropertyCursor>(){

        @Override
        protected TxSinglePropertyCursor create() {
            return new TxSinglePropertyCursor(this);
        }
    };
    private boolean hasChanges;
    private boolean hasDataChanges;

    public TxState() {
        this.singleRelationshipCursor = new InstanceCache<TxSingleRelationshipCursor>(){

            @Override
            protected TxSingleRelationshipCursor create() {
                return new TxSingleRelationshipCursor((TransactionState)TxState.this, this);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<TxIteratorRelationshipCursor>(){

            @Override
            protected TxIteratorRelationshipCursor create() {
                return new TxIteratorRelationshipCursor((TransactionState)TxState.this, this);
            }
        };
    }

    @Override
    public void accept(TxStateVisitor visitor) throws ConstraintValidationException, CreateConstraintFailureException {
        if (this.nodes != null) {
            this.nodes.accept((DiffSetsVisitor)TxState.createdNodesVisitor(visitor));
        }
        if (this.relationships != null) {
            this.relationships.accept((DiffSetsVisitor)TxState.createdRelationshipsVisitor(this, visitor));
            this.relationships.accept((DiffSetsVisitor)TxState.deletedRelationshipsVisitor(visitor));
        }
        if (this.nodes != null) {
            this.nodes.accept((DiffSetsVisitor)TxState.deletedNodesVisitor(visitor));
        }
        for (NodeState nodeState : this.modifiedNodes()) {
            nodeState.accept(TxState.nodeVisitor(visitor));
        }
        for (RelationshipState relationshipState : this.modifiedRelationships()) {
            relationshipState.accept(TxState.relVisitor(visitor));
        }
        if (this.graphState != null) {
            this.graphState.accept(TxState.graphPropertyVisitor(visitor));
        }
        if (this.indexChanges != null) {
            this.indexChanges.accept((DiffSetsVisitor)TxState.indexVisitor(visitor));
        }
        if (this.constraintsChanges != null) {
            this.constraintsChanges.accept((DiffSetsVisitor)TxState.constraintsVisitor(visitor));
        }
        if (this.createdLabelTokens != null) {
            for (Map.Entry entry : this.createdLabelTokens.entrySet()) {
                visitor.visitCreatedLabelToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdPropertyKeyTokens != null) {
            for (Map.Entry entry : this.createdPropertyKeyTokens.entrySet()) {
                visitor.visitCreatedPropertyKeyToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdRelationshipTypeTokens != null) {
            for (Map.Entry entry : this.createdRelationshipTypeTokens.entrySet()) {
                visitor.visitCreatedRelationshipTypeToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
    }

    private static DiffSetsVisitor<Long> deletedNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long element) {
                visitor.visitDeletedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitAdded(Long element) {
                visitor.visitCreatedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> deletedRelationshipsVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long id) {
                visitor.visitDeletedRelationship(id);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdRelationshipsVisitor(ReadableTransactionState tx, final TxStateVisitor visitor) {
        return new RelationshipChangeVisitorAdapter(tx){

            @Override
            protected void visitAddedRelationship(long relationshipId, int type, long startNode, long endNode) throws ConstraintValidationException {
                visitor.visitCreatedRelationship(relationshipId, type, startNode, endNode);
            }
        };
    }

    private static DiffSetsVisitor<ConstraintDescriptor> constraintsVisitor(TxStateVisitor visitor) {
        return new ConstraintDiffSetsVisitor(visitor);
    }

    private static DiffSetsVisitor<IndexDescriptor> indexVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor index) throws ConstraintValidationException, CreateConstraintFailureException {
                visitor.visitAddedIndex(index);
            }

            @Override
            public void visitRemoved(IndexDescriptor index) throws ConstraintValidationException {
                visitor.visitRemovedIndex(index);
            }
        };
    }

    private static NodeState.Visitor nodeVisitor(final TxStateVisitor visitor) {
        return new NodeState.Visitor(){

            @Override
            public void visitLabelChanges(long nodeId, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationException {
                visitor.visitNodeLabelChanges(nodeId, added, removed);
            }

            @Override
            public void visitPropertyChanges(long entityId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
                visitor.visitNodePropertyChanges(entityId, added, changed, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor relVisitor(TxStateVisitor visitor) {
        return visitor::visitRelPropertyChanges;
    }

    private static PropertyContainerState.Visitor graphPropertyVisitor(TxStateVisitor visitor) {
        return (entityId, added, changed, removed) -> visitor.visitGraphPropertyChanges(added, changed, removed);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public Iterable<NodeState> modifiedNodes() {
        return NODE_STATE.values(this);
    }

    private DiffSets<Long> getOrCreateLabelStateNodeDiffSets(int labelId) {
        return ((LabelState.Mutable)LABEL_STATE.getOrCreate(this, labelId)).getOrCreateNodeDiffSets();
    }

    @Override
    public ReadableDiffSets<Integer> nodeStateLabelDiffSets(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).labelDiffSets();
    }

    private DiffSets<Integer> getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    @Override
    public Iterator<StorageProperty> augmentGraphProperties(Iterator<StorageProperty> original) {
        if (this.graphState != null) {
            return this.graphState.augmentProperties(original);
        }
        return original;
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded((Object)nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded((Object)relationshipId);
    }

    private void changed() {
        this.hasChanges = true;
    }

    private void dataChanged() {
        this.changed();
        this.hasDataChanges = true;
    }

    @Override
    public void nodeDoCreate(long id) {
        this.nodes().add((Object)id);
        this.dataChanged();
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        if (this.nodes().remove((Object)nodeId)) {
            this.recordNodeDeleted(nodeId);
        }
        if (this.nodeStatesMap != null && (nodeState = this.nodeStatesMap.remove(nodeId)) != null) {
            ReadableDiffSets<Integer> diff = nodeState.labelDiffSets();
            for (Integer label : diff.getAdded()) {
                this.getOrCreateLabelStateNodeDiffSets(label).remove((Object)nodeId);
            }
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add((Object)id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, Direction.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.dataChanged();
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodesDeletedInTx != null && this.nodesDeletedInTx.contains(nodeId);
    }

    @Override
    public boolean nodeModifiedInThisTx(long nodeId) {
        return this.nodeIsAddedInThisTx(nodeId) || this.nodeIsDeletedInThisTx(nodeId) || this.hasNodeState(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        RelationshipStateImpl removed;
        if (this.relationships().remove((Object)id)) {
            this.recordRelationshipDeleted(id);
        }
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, Direction.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        ((RelationshipState)RELATIONSHIP_STATE.get(this, relationshipId)).accept(this::relationshipDoDelete);
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.relationshipsDeletedInTx != null && this.relationshipsDeletedInTx.contains(relationshipId);
    }

    @Override
    public void nodeDoAddProperty(long nodeId, int newPropertyKeyId, Value value) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        nodeState.addProperty(newPropertyKeyId, value);
        this.nodePropertyChanges().addProperty(nodeId, newPropertyKeyId, value);
        this.dataChanged();
    }

    @Override
    public void nodeDoChangeProperty(long nodeId, int propertyKeyId, Value replacedValue, Value newValue) {
        this.getOrCreateNodeState(nodeId).changeProperty(propertyKeyId, newValue);
        this.nodePropertyChanges().changeProperty(nodeId, propertyKeyId, replacedValue, newValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void graphDoReplaceProperty(int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateGraphState().changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateGraphState().addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, int propertyKeyId, Value removedValue) {
        this.getOrCreateNodeState(nodeId).removeProperty(propertyKeyId, removedValue);
        this.nodePropertyChanges().removeProperty(nodeId, propertyKeyId, removedValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, int propertyKeyId, Value removedValue) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(propertyKeyId, removedValue);
        this.dataChanged();
    }

    @Override
    public void graphDoRemoveProperty(int propertyKeyId, Value removedValue) {
        this.getOrCreateGraphState().removeProperty(propertyKeyId, removedValue);
        this.dataChanged();
    }

    @Override
    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add((Object)nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add((Object)labelId);
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove((Object)nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove((Object)labelId);
        this.dataChanged();
    }

    @Override
    public void labelDoCreateForName(String labelName, int id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = new HashMap<Integer, String>();
        }
        this.createdLabelTokens.put(id, labelName);
        this.changed();
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = new HashMap<Integer, String>();
        }
        this.createdPropertyKeyTokens.put(id, propertyKeyName);
        this.changed();
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = new HashMap<Integer, String>();
        }
        this.createdRelationshipTypeTokens.put(id, labelName);
        this.changed();
    }

    @Override
    public NodeState getNodeState(long id) {
        return (NodeState)NODE_STATE.get(this, id);
    }

    @Override
    public RelationshipState getRelationshipState(long id) {
        return (RelationshipState)RELATIONSHIP_STATE.get(this, id);
    }

    @Override
    public Cursor<NodeItem> augmentSingleNodeCursor(Cursor<NodeItem> cursor, long nodeId) {
        return this.hasChanges ? this.singleNodeCursor.get().init(cursor, nodeId) : cursor;
    }

    @Override
    public Cursor<PropertyItem> augmentPropertyCursor(Cursor<PropertyItem> cursor, PropertyContainerState propertyContainerState) {
        return propertyContainerState.hasChanges() ? this.propertyCursor.get().init(cursor, propertyContainerState) : cursor;
    }

    @Override
    public Cursor<PropertyItem> augmentSinglePropertyCursor(Cursor<PropertyItem> cursor, PropertyContainerState propertyContainerState, int propertyKeyId) {
        return propertyContainerState.hasChanges() ? this.singlePropertyCursor.get().init(cursor, propertyContainerState, propertyKeyId) : cursor;
    }

    @Override
    public PrimitiveIntSet augmentLabels(PrimitiveIntSet labels, NodeState nodeState) {
        ReadableDiffSets<Integer> labelDiffSets = nodeState.labelDiffSets();
        if (!labelDiffSets.isEmpty()) {
            labelDiffSets.getRemoved().forEach(arg_0 -> ((PrimitiveIntSet)labels).remove(arg_0));
            labelDiffSets.getAdded().forEach(arg_0 -> ((PrimitiveIntSet)labels).add(arg_0));
        }
        return labels;
    }

    @Override
    public Cursor<RelationshipItem> augmentSingleRelationshipCursor(Cursor<RelationshipItem> cursor, long relationshipId) {
        return this.hasChanges ? this.singleRelationshipCursor.get().init(cursor, relationshipId) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentNodeRelationshipCursor(Cursor<RelationshipItem> cursor, NodeState nodeState, Direction direction) {
        return nodeState.hasChanges() ? this.iteratorRelationshipCursor.get().init(cursor, nodeState.getAddedRelationships(direction)) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentNodeRelationshipCursor(Cursor<RelationshipItem> cursor, NodeState nodeState, Direction direction, int[] relTypes) {
        return nodeState.hasChanges() ? this.iteratorRelationshipCursor.get().init(cursor, nodeState.getAddedRelationships(direction, relTypes)) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentRelationshipsGetAllCursor(Cursor<RelationshipItem> cursor) {
        return this.hasChanges && this.relationships != null && !this.relationships.isEmpty() ? this.iteratorRelationshipCursor.get().init(cursor, PrimitiveLongCollections.toPrimitiveIterator(this.relationships.getAdded().iterator())) : cursor;
    }

    @Override
    public ReadableDiffSets<Long> nodesWithLabelChanged(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).nodeDiffSets();
    }

    @Override
    public void indexRuleDoAdd(IndexDescriptor descriptor) {
        DiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (!diff.unRemove((Object)descriptor)) {
            diff.add((Object)descriptor);
        }
        this.changed();
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChangesDiffSets().remove((Object)descriptor);
        this.changed();
    }

    @Override
    public boolean indexDoUnRemove(IndexDescriptor descriptor) {
        return this.indexChangesDiffSets().unRemove((Object)descriptor);
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel(labelId));
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.indexChanges);
    }

    private DiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    @Override
    public ReadableDiffSets<Long> addedAndRemovedNodes() {
        return ReadableDiffSets.Empty.ifNull(this.nodes);
    }

    private DiffSets<Long> nodes() {
        if (this.nodes == null) {
            this.nodes = new DiffSets();
        }
        return this.nodes;
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentDegree(direction, degree);
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction, int typeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentDegree(direction, degree, typeId);
    }

    @Override
    public PrimitiveIntSet nodeRelationshipTypes(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).relationshipTypes();
    }

    @Override
    public ReadableRelationshipDiffSets<Long> addedAndRemovedRelationships() {
        return ReadableRelationshipDiffSets.Empty.ifNull(this.relationships);
    }

    private RelationshipDiffSets<Long> relationships() {
        if (this.relationships == null) {
            this.relationships = new RelationshipDiffSets(this);
        }
        return this.relationships;
    }

    @Override
    public Iterable<RelationshipState> modifiedRelationships() {
        return RELATIONSHIP_STATE.values(this);
    }

    private NodeStateImpl getOrCreateNodeState(long nodeId) {
        return (NodeStateImpl)NODE_STATE.getOrCreate(this, nodeId);
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId) {
        return (RelationshipStateImpl)RELATIONSHIP_STATE.getOrCreate(this, relationshipId);
    }

    private GraphState getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphState();
        }
        return this.graphState;
    }

    @Override
    public void constraintDoAdd(IndexBackedConstraintDescriptor constraint, long indexId) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.changed();
    }

    @Override
    public void constraintDoAdd(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.changed();
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForLabel(int labelId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel(labelId));
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForSchema(SchemaDescriptor descriptor) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptor.equalTo(descriptor));
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForRelationshipType(int relTypeId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType(relTypeId));
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private DiffSets<ConstraintDescriptor> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().remove((Object)constraint);
        if (constraint.enforcesUniqueness()) {
            this.indexDoDrop(this.getIndexForIndexBackedConstraint((IndexBackedConstraintDescriptor)constraint));
        }
        this.changed();
    }

    @Override
    public boolean constraintDoUnRemove(ConstraintDescriptor constraint) {
        return this.constraintsChangesDiffSets().unRemove((Object)constraint);
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return Iterables.map(this::getIndexForIndexBackedConstraint, this.createdConstraintIndexesByConstraint.keySet());
        }
        return Iterables.empty();
    }

    @Override
    public Long indexCreatedForConstraint(ConstraintDescriptor constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : this.createdConstraintIndexesByConstraint.get(constraint);
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForScan(IndexDescriptor descriptor) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForScan(descriptor.schema()));
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForSeek(IndexDescriptor descriptor, ValueTuple values) {
        assert (values != null);
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForSeek(descriptor.schema(), values, false));
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForRangeSeekByNumber(IndexDescriptor descriptor, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForRangeSeekByNumber(descriptor, lower, includeLower, upper, includeUpper));
    }

    private ReadableDiffSets<Long> getIndexUpdatesForRangeSeekByNumber(IndexDescriptor descriptor, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        TreeMap<ValueTuple, DiffSets<Long>> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return null;
        }
        if (lower == null) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.MIN_NUMBER});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.numberValue((Number)lower)});
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.MAX_NUMBER});
            selectedIncludeUpper = true;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.numberValue((Number)upper)});
            selectedIncludeUpper = includeUpper;
        }
        DiffSets<Long> diffs = new DiffSets<Long>();
        Collection inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper).values();
        for (DiffSets diffForSpecificValue : inRange) {
            diffs.addAll(diffForSpecificValue.getAdded().iterator());
            diffs.removeAll(diffForSpecificValue.getRemoved().iterator());
        }
        return diffs;
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForRangeSeekByString(IndexDescriptor descriptor, String lower, boolean includeLower, String upper, boolean includeUpper) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForRangeSeekByString(descriptor, lower, includeLower, upper, includeUpper));
    }

    private ReadableDiffSets<Long> getIndexUpdatesForRangeSeekByString(IndexDescriptor descriptor, String lower, boolean includeLower, String upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        TreeMap<ValueTuple, DiffSets<Long>> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return null;
        }
        if (lower == null) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.MIN_STRING});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)lower)});
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.MAX_STRING});
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)upper)});
            selectedIncludeUpper = includeUpper;
        }
        DiffSets<Long> diffs = new DiffSets<Long>();
        Collection inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper).values();
        for (DiffSets diffForSpecificValue : inRange) {
            diffs.addAll(diffForSpecificValue.getAdded().iterator());
            diffs.removeAll(diffForSpecificValue.getRemoved().iterator());
        }
        return diffs;
    }

    @Override
    public ReadableDiffSets<Long> indexUpdatesForRangeSeekByPrefix(IndexDescriptor descriptor, String prefix) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdatesForRangeSeekByPrefix(descriptor, prefix));
    }

    private ReadableDiffSets<Long> getIndexUpdatesForRangeSeekByPrefix(IndexDescriptor descriptor, String prefix) {
        Map.Entry<ValueTuple, DiffSets<Long>> entry;
        ValueTuple key;
        TreeMap<ValueTuple, DiffSets<Long>> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return null;
        }
        ValueTuple floor = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)prefix)});
        DiffSets<Long> diffs = new DiffSets<Long>();
        Iterator<Map.Entry<ValueTuple, DiffSets<Long>>> iterator = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator.hasNext() && ((TextValue)(key = (entry = iterator.next()).getKey()).getOnlyValue()).stringValue().startsWith(prefix)) {
            DiffSets<Long> diffSets = entry.getValue();
            diffs.addAll(diffSets.getAdded().iterator());
            diffs.removeAll(diffSets.getRemoved().iterator());
        }
        return diffs;
    }

    private TreeMap<ValueTuple, DiffSets<Long>> getSortedIndexUpdates(LabelSchemaDescriptor descriptor) {
        TreeMap<ValueTuple, DiffSets<Long>> sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, DiffSets<Long>> updates = this.indexUpdates.get(descriptor);
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap<ValueTuple, DiffSets<Long>>)updates;
        } else {
            sortedUpdates = new TreeMap<ValueTuple, DiffSets<Long>>(ValueTuple.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put(descriptor, sortedUpdates);
        }
        return sortedUpdates;
    }

    @Override
    public void indexDoUpdateEntry(LabelSchemaDescriptor descriptor, long nodeId, ValueTuple propertiesBefore, ValueTuple propertiesAfter) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        Map<ValueTuple, DiffSets<Long>> updates = this.getIndexUpdatesByDescriptor(descriptor, true);
        if (propertiesBefore != null) {
            DiffSets<Long> before = this.getIndexUpdatesForSeek(updates, propertiesBefore, true);
            before.remove((Object)nodeId);
            if (before.getRemoved().contains(nodeId)) {
                nodeState.addIndexDiff(before);
            } else {
                nodeState.removeIndexDiff(before);
            }
        }
        if (propertiesAfter != null) {
            DiffSets<Long> after = this.getIndexUpdatesForSeek(updates, propertiesAfter, true);
            after.add((Object)nodeId);
            if (after.getAdded().contains(nodeId)) {
                nodeState.addIndexDiff(after);
            } else {
                nodeState.removeIndexDiff(after);
            }
        }
    }

    private DiffSets<Long> getIndexUpdatesForSeek(LabelSchemaDescriptor schema, ValueTuple values, boolean create) {
        Map<ValueTuple, DiffSets<Long>> updates = this.getIndexUpdatesByDescriptor(schema, create);
        if (updates != null) {
            return this.getIndexUpdatesForSeek(updates, values, create);
        }
        return null;
    }

    private DiffSets<Long> getIndexUpdatesForSeek(Map<ValueTuple, DiffSets<Long>> updates, ValueTuple values, boolean create) {
        DiffSets<Long> diffs = updates.get(values);
        if (diffs == null && create) {
            diffs = new DiffSets();
            updates.put(values, diffs);
        }
        return diffs;
    }

    private Map<ValueTuple, DiffSets<Long>> getIndexUpdatesByDescriptor(LabelSchemaDescriptor schema, boolean create) {
        Map<ValueTuple, DiffSets<Long>> updates;
        if (this.indexUpdates == null) {
            if (!create) {
                return null;
            }
            this.indexUpdates = new HashMap<LabelSchemaDescriptor, Map<ValueTuple, DiffSets<Long>>>();
        }
        if ((updates = this.indexUpdates.get(schema)) == null) {
            if (!create) {
                return null;
            }
            updates = new HashMap<ValueTuple, DiffSets<Long>>();
            this.indexUpdates.put(schema, updates);
        }
        return updates;
    }

    private DiffSets<Long> getIndexUpdatesForScan(LabelSchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, DiffSets<Long>> updates = this.indexUpdates.get(schema);
        if (updates == null) {
            return null;
        }
        DiffSets<Long> diffs = new DiffSets<Long>();
        for (DiffSets<Long> diffSet : updates.values()) {
            diffs.addAll(diffSet.getAdded().iterator());
            diffs.removeAll(diffSet.getRemoved().iterator());
        }
        return diffs;
    }

    private Map<IndexBackedConstraintDescriptor, Long> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new HashMap<IndexBackedConstraintDescriptor, Long>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private IndexDescriptor getIndexForIndexBackedConstraint(IndexBackedConstraintDescriptor constraint) {
        return constraint.ownedIndexDescriptor();
    }

    private boolean hasNodeState(long nodeId) {
        return this.nodeStatesMap != null && this.nodeStatesMap.containsKey(nodeId);
    }

    private PropertyChanges nodePropertyChanges() {
        return this.propertyChangesForNodes == null ? (this.propertyChangesForNodes = new PropertyChanges()) : this.propertyChangesForNodes;
    }

    @Override
    public PrimitiveLongIterator augmentNodesGetAll(PrimitiveLongIterator committed) {
        return this.addedAndRemovedNodes().augment(committed);
    }

    @Override
    public RelationshipIterator augmentRelationshipsGetAll(RelationshipIterator committed) {
        return this.addedAndRemovedRelationships().augment(committed);
    }

    @Override
    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return ((RelationshipState)RELATIONSHIP_STATE.get(this, relId)).accept(visitor);
    }

    @Override
    public boolean hasDataChanges() {
        return this.hasDataChanges;
    }

    private void recordNodeDeleted(long id) {
        if (this.nodesDeletedInTx == null) {
            this.nodesDeletedInTx = Primitive.longSet();
        }
        this.nodesDeletedInTx.add(id);
    }

    private void recordRelationshipDeleted(long id) {
        if (this.relationshipsDeletedInTx == null) {
            this.relationshipsDeletedInTx = Primitive.longSet();
        }
        this.relationshipsDeletedInTx.add(id);
    }

    private static class ConstraintDiffSetsVisitor
    implements DiffSetsVisitor<ConstraintDescriptor> {
        private final TxStateVisitor visitor;

        ConstraintDiffSetsVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visitAdded(ConstraintDescriptor constraint) throws ConstraintValidationException, CreateConstraintFailureException {
            this.visitor.visitAddedConstraint(constraint);
        }

        @Override
        public void visitRemoved(ConstraintDescriptor constraint) throws ConstraintValidationException {
            this.visitor.visitRemovedConstraint(constraint);
        }
    }
}

