/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.logging.Log;

public class LoggingMonitor
implements IndexProvider.Monitor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(long indexId, SchemaIndexDescriptor schemaIndexDescriptor, String action, Exception cause) {
        this.log.error("Failed to open index:" + indexId + ". " + action, (Throwable)cause);
    }

    @Override
    public void recoveryCleanupRegistered(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
        this.log.info("Schema index cleanup job registered: " + this.indexDescription(indexFile, schemaIndexDescriptor));
    }

    @Override
    public void recoveryCleanupStarted(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
        this.log.info("Schema index cleanup job started: " + this.indexDescription(indexFile, schemaIndexDescriptor));
    }

    @Override
    public void recoveryCleanupFinished(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor, long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", "Schema index cleanup job finished: " + this.indexDescription(indexFile, schemaIndexDescriptor) + " ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration(durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
        this.log.info("Schema index cleanup job closed: " + this.indexDescription(indexFile, schemaIndexDescriptor));
    }

    @Override
    public void recoveryCleanupFailed(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor, Throwable throwable) {
        this.log.info(String.format("Schema index cleanup job failed: %s.%nCaused by: %s", this.indexDescription(indexFile, schemaIndexDescriptor), ExceptionUtils.getStackTrace((Throwable)throwable)));
    }

    private String indexDescription(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
        return "descriptor=" + schemaIndexDescriptor.toString() + ", indexFile=" + indexFile.getAbsolutePath();
    }
}

