/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public final class IndexMap
implements Cloneable {
    private final PrimitiveLongObjectMap<IndexProxy> indexesById;
    private final Map<SchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final Map<SchemaDescriptor, Long> indexIdsByDescriptor;
    private final PrimitiveIntObjectMap<Set<SchemaDescriptor>> descriptorsByLabel;
    private final PrimitiveIntObjectMap<Set<SchemaDescriptor>> descriptorsByProperty;

    public IndexMap() {
        this((PrimitiveLongObjectMap<IndexProxy>)Primitive.longObjectMap(), new HashMap<SchemaDescriptor, IndexProxy>(), new HashMap<SchemaDescriptor, Long>());
    }

    IndexMap(PrimitiveLongObjectMap<IndexProxy> indexesById) {
        this(indexesById, IndexMap.indexesByDescriptor(indexesById), IndexMap.indexIdsByDescriptor(indexesById));
    }

    private IndexMap(PrimitiveLongObjectMap<IndexProxy> indexesById, Map<SchemaDescriptor, IndexProxy> indexesByDescriptor, Map<SchemaDescriptor, Long> indexIdsByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
        this.descriptorsByLabel = Primitive.intObjectMap();
        this.descriptorsByProperty = Primitive.intObjectMap();
        for (SchemaDescriptor schema : indexesByDescriptor.keySet()) {
            this.addDescriptorToLookups(schema);
        }
    }

    public IndexProxy getIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get(descriptor);
    }

    public void putIndexProxy(long indexId, IndexProxy indexProxy) {
        SchemaDescriptor schema = indexProxy.getDescriptor().schema();
        this.indexesById.put(indexId, (Object)indexProxy);
        this.indexesByDescriptor.put(schema, indexProxy);
        this.indexIdsByDescriptor.put(schema, indexId);
        this.addDescriptorToLookups(schema);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = (IndexProxy)this.indexesById.remove(indexId);
        if (removedProxy == null) {
            return null;
        }
        SchemaDescriptor schema = removedProxy.getDescriptor().schema();
        this.indexesByDescriptor.remove(schema);
        this.removeFromLookup(schema.keyId(), schema, this.descriptorsByLabel);
        for (int propertyId : schema.getPropertyIds()) {
            this.removeFromLookup(propertyId, schema, this.descriptorsByProperty);
        }
        return removedProxy;
    }

    public void forEachIndexProxy(BiConsumer<Long, IndexProxy> consumer) {
        this.indexesById.visitEntries((key, indexProxy) -> {
            consumer.accept(key, (IndexProxy)indexProxy);
            return false;
        });
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public Set<SchemaDescriptor> getRelatedIndexes(long[] changedLabels, long[] unchangedLabels, PrimitiveIntSet properties) {
        if (changedLabels.length == 1 && properties.isEmpty()) {
            Set descriptors = (Set)this.descriptorsByLabel.get((int)changedLabels[0]);
            return descriptors == null ? Collections.emptySet() : descriptors;
        }
        if (changedLabels.length == 0 && properties.size() == 1) {
            return this.getDescriptorsByProperties(unchangedLabels, properties);
        }
        Set<SchemaDescriptor> descriptors = this.extractIndexesByLabels(changedLabels);
        descriptors.addAll(this.getDescriptorsByProperties(unchangedLabels, properties));
        return descriptors;
    }

    public IndexMap clone() {
        return new IndexMap(this.clonePrimitiveMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), this.cloneMap(this.indexIdsByDescriptor));
    }

    public Iterator<SchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public PrimitiveLongIterator indexIds() {
        return this.indexesById.iterator();
    }

    public int size() {
        return this.indexesById.size();
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map.size());
        shallowCopy.putAll(map);
        return shallowCopy;
    }

    private PrimitiveLongObjectMap<IndexProxy> clonePrimitiveMap(PrimitiveLongObjectMap<IndexProxy> indexesById) {
        return PrimitiveLongCollections.copy(indexesById);
    }

    private void addDescriptorToLookups(SchemaDescriptor schema) {
        this.addToLookup(schema.keyId(), schema, this.descriptorsByLabel);
        for (int propertyId : schema.getPropertyIds()) {
            this.addToLookup(propertyId, schema, this.descriptorsByProperty);
        }
    }

    private void addToLookup(int key, SchemaDescriptor schema, PrimitiveIntObjectMap<Set<SchemaDescriptor>> lookup) {
        HashSet<SchemaDescriptor> descriptors = (HashSet<SchemaDescriptor>)lookup.get(key);
        if (descriptors == null) {
            descriptors = new HashSet<SchemaDescriptor>();
            lookup.put(key, descriptors);
        }
        descriptors.add(schema);
    }

    private void removeFromLookup(int key, SchemaDescriptor schema, PrimitiveIntObjectMap<Set<SchemaDescriptor>> lookup) {
        Set descriptors = (Set)lookup.get(key);
        descriptors.remove(schema);
        if (descriptors.isEmpty()) {
            lookup.remove(key);
        }
    }

    private static Map<SchemaDescriptor, IndexProxy> indexesByDescriptor(PrimitiveLongObjectMap<IndexProxy> indexesById) {
        HashMap<SchemaDescriptor, IndexProxy> map = new HashMap<SchemaDescriptor, IndexProxy>();
        for (IndexProxy proxy : indexesById.values()) {
            map.put(proxy.schema(), proxy);
        }
        return map;
    }

    private static Map<SchemaDescriptor, Long> indexIdsByDescriptor(PrimitiveLongObjectMap<IndexProxy> indexesById) {
        HashMap<SchemaDescriptor, Long> map = new HashMap<SchemaDescriptor, Long>();
        indexesById.visitEntries((key, indexProxy) -> {
            map.put(indexProxy.schema(), key);
            return false;
        });
        return map;
    }

    private Set<SchemaDescriptor> getDescriptorsByProperties(long[] unchangedLabels, PrimitiveIntSet properties) {
        int nIndexesForLabels = this.countIndexesByLabels(unchangedLabels);
        int nIndexesForProperties = this.countIndexesByProperties(properties);
        if (nIndexesForLabels == 0 || nIndexesForProperties == 0) {
            return Collections.emptySet();
        }
        if (nIndexesForLabels < nIndexesForProperties) {
            return this.extractIndexesByLabels(unchangedLabels);
        }
        return this.extractIndexesByProperties(properties);
    }

    private Set<SchemaDescriptor> extractIndexesByLabels(long[] labels) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        for (long label : labels) {
            Set forLabel = (Set)this.descriptorsByLabel.get((int)label);
            if (forLabel == null) continue;
            set.addAll(forLabel);
        }
        return set;
    }

    private int countIndexesByLabels(long[] labels) {
        int count = 0;
        for (long label : labels) {
            Set forLabel = (Set)this.descriptorsByLabel.get((int)label);
            if (forLabel == null) continue;
            count += forLabel.size();
        }
        return count;
    }

    private Set<SchemaDescriptor> extractIndexesByProperties(PrimitiveIntSet properties) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        PrimitiveIntIterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)this.descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            set.addAll(forProperty);
        }
        return set;
    }

    private int countIndexesByProperties(PrimitiveIntSet properties) {
        int count = 0;
        PrimitiveIntIterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Set forProperty = (Set)this.descriptorsByProperty.get(iterator.next());
            if (forProperty == null) continue;
            count += forProperty.size();
        }
        return count;
    }
}

