/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.impl.core.IsolatedTransactionTokenCreator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;

public class DefaultLabelIdCreator
extends IsolatedTransactionTokenCreator {
    public DefaultLabelIdCreator(Supplier<Kernel> kernelSupplier, IdGeneratorFactory idGeneratorFactory) {
        super(kernelSupplier, idGeneratorFactory);
    }

    @Override
    protected int createKey(Transaction transaction, String name) throws IllegalTokenNameException, TooManyLabelsException {
        int id = (int)this.idGeneratorFactory.get(IdType.LABEL_TOKEN).nextId();
        transaction.tokenWrite().labelCreateForName(name, id);
        return id;
    }
}

