/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.kernel.impl.newapi.UnionIndexCapability;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.values.storable.ValueCategory;

public class FusionIndexProvider
extends IndexProvider {
    private final boolean archiveFailedIndex;
    private final InstanceSelector<IndexProvider> providers;
    private final SlotSelector slotSelector;
    private final DropAction dropAction;

    public FusionIndexProvider(IndexProvider stringProvider, IndexProvider numberProvider, IndexProvider spatialProvider, IndexProvider temporalProvider, IndexProvider luceneProvider, SlotSelector slotSelector, IndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructure, FileSystemAbstraction fs, boolean archiveFailedIndex) {
        super(descriptor, priority, directoryStructure);
        IndexProvider[] providers = new IndexProvider[5];
        this.fillProvidersArray(providers, stringProvider, numberProvider, spatialProvider, temporalProvider, luceneProvider);
        slotSelector.validateSatisfied(providers);
        this.archiveFailedIndex = archiveFailedIndex;
        this.slotSelector = slotSelector;
        this.providers = new InstanceSelector<IndexProvider>(providers);
        this.dropAction = new FileSystemDropAction(fs, this.directoryStructure());
    }

    private void fillProvidersArray(IndexProvider[] providers, IndexProvider stringProvider, IndexProvider numberProvider, IndexProvider spatialProvider, IndexProvider temporalProvider, IndexProvider luceneProvider) {
        providers[0] = stringProvider;
        providers[1] = numberProvider;
        providers[2] = spatialProvider;
        providers[3] = temporalProvider;
        providers[4] = luceneProvider;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        IndexPopulator[] populators = this.providers.instancesAs(new IndexPopulator[5], provider -> provider.getPopulator(indexId, descriptor, samplingConfig));
        return new FusionIndexPopulator(this.slotSelector, new InstanceSelector<IndexPopulator>(populators), indexId, this.dropAction, this.archiveFailedIndex);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        IndexAccessor[] accessors = this.providers.instancesAs(new IndexAccessor[5], provider -> provider.getOnlineAccessor(indexId, descriptor, samplingConfig));
        return new FusionIndexAccessor(this.slotSelector, new InstanceSelector<IndexAccessor>(accessors), indexId, descriptor, this.dropAction);
    }

    @Override
    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        StringBuilder builder = new StringBuilder();
        this.providers.forAll(p -> this.writeFailure(p.getClass().getSimpleName(), builder, (IndexProvider)p, indexId, descriptor));
        String failure = builder.toString();
        if (!failure.isEmpty()) {
            return failure;
        }
        throw new IllegalStateException("None of the indexes were in a failed state");
    }

    private void writeFailure(String indexName, StringBuilder builder, IndexProvider provider, long indexId, SchemaIndexDescriptor descriptor) {
        try {
            String failure = provider.getPopulationFailure(indexId, descriptor);
            builder.append(indexName);
            builder.append(": ");
            builder.append(failure);
            builder.append(' ');
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        InternalIndexState[] states = this.providers.instancesAs(new InternalIndexState[5], p -> p.getInitialState(indexId, descriptor));
        if (Arrays.stream(states).anyMatch(state -> state == InternalIndexState.FAILED)) {
            return InternalIndexState.FAILED;
        }
        if (Arrays.stream(states).anyMatch(state -> state == InternalIndexState.POPULATING)) {
            return InternalIndexState.POPULATING;
        }
        return InternalIndexState.ONLINE;
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        IndexCapability[] capabilities = this.providers.instancesAs(new IndexCapability[5], provider -> provider.getCapability(schemaIndexDescriptor));
        return new UnionIndexCapability(capabilities){

            @Override
            public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
                if (valueCategories.length == 1 && valueCategories[0] == ValueCategory.UNKNOWN) {
                    return ORDER_NONE;
                }
                return super.orderCapability(valueCategories);
            }
        };
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private static class FileSystemDropAction
    implements DropAction {
        private final FileSystemAbstraction fs;
        private final IndexDirectoryStructure directoryStructure;

        FileSystemDropAction(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure) {
            this.fs = fs;
            this.directoryStructure = directoryStructure;
        }

        @Override
        public void drop(long indexId, boolean archiveExistentIndex) throws IOException {
            File rootIndexDirectory = this.directoryStructure.directoryForIndex(indexId);
            if (archiveExistentIndex && !FileUtils.isEmptyDirectory((File)rootIndexDirectory)) {
                ZipUtils.zip((FileSystemAbstraction)this.fs, (File)rootIndexDirectory, (File)this.archiveFile(rootIndexDirectory));
            }
            this.fs.deleteRecursively(rootIndexDirectory);
        }

        private File archiveFile(File folder) {
            return new File(folder.getParent(), "archive-" + folder.getName() + "-" + System.currentTimeMillis() + ".zip");
        }
    }

    @FunctionalInterface
    static interface DropAction {
        public void drop(long var1, boolean var3) throws IOException;

        default public void drop(long indexId) throws IOException {
            this.drop(indexId, false);
        }
    }
}

