/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveArrays;
import org.neo4j.collection.primitive.PrimitiveLongCollection;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

class TwoPhaseNodeForRelationshipLocking {
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long firstRelId;
    private long[] sortedNodeIds;
    private static final long[] EMPTY = new long[0];
    private final Locks.Client locks;
    private final LockTracer lockTracer;

    TwoPhaseNodeForRelationshipLocking(ThrowingConsumer<Long, KernelException> relIdAction, Locks.Client locks, LockTracer lockTracer) {
        this.relIdAction = relIdAction;
        this.locks = locks;
        this.lockTracer = lockTracer;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, Transaction transaction, NodeCursor nodes) throws KernelException {
        boolean retry;
        do {
            retry = false;
            this.firstRelId = -1L;
            this.collectAndSortNodeIds(nodeId, transaction, nodes);
            this.lockAllNodes(this.sortedNodeIds);
            Read read = transaction.dataRead();
            read.singleNode(nodeId, nodes);
            if (!nodes.next()) continue;
            RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);
            boolean first = true;
            while (rels.next() && !retry) {
                retry = this.performAction(rels.relationshipReference(), first);
                first = false;
            }
        } while (retry);
    }

    private void collectAndSortNodeIds(long nodeId, Transaction transaction, NodeCursor nodes) {
        PrimitiveLongSet nodeIdSet = Primitive.longSet();
        nodeIdSet.add(nodeId);
        Read read = transaction.dataRead();
        read.singleNode(nodeId, nodes);
        if (!nodes.next()) {
            this.sortedNodeIds = EMPTY;
            return;
        }
        RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);
        while (rels.next()) {
            if (this.firstRelId == -1L) {
                this.firstRelId = rels.relationshipReference();
            }
            nodeIdSet.add(rels.sourceNodeReference());
            nodeIdSet.add(rels.targetNodeReference());
        }
        long[] nodeIds = PrimitiveArrays.of((PrimitiveLongCollection)nodeIdSet);
        Arrays.sort(nodeIds);
        this.sortedNodeIds = nodeIds;
    }

    private void lockAllNodes(long[] nodeIds) {
        this.locks.acquireExclusive(this.lockTracer, ResourceTypes.NODE, nodeIds);
    }

    private void unlockAllNodes(long[] nodeIds) {
        this.locks.releaseExclusive(ResourceTypes.NODE, nodeIds);
    }

    private boolean performAction(long rel, boolean first) throws KernelException {
        if (first && rel != this.firstRelId) {
            this.unlockAllNodes(this.sortedNodeIds);
            this.sortedNodeIds = null;
            return true;
        }
        this.relIdAction.accept((Object)rel);
        return false;
    }
}

