/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

class LocalTimeLayout
extends IndexLayout<LocalTimeIndexKey, NativeIndexValue> {
    LocalTimeLayout() {
        super("Tlt", 0, 1);
    }

    public LocalTimeIndexKey newKey() {
        return new LocalTimeIndexKey();
    }

    public LocalTimeIndexKey copyKey(LocalTimeIndexKey key, LocalTimeIndexKey into) {
        into.nanoOfDay = key.nanoOfDay;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(LocalTimeIndexKey key) {
        return 16;
    }

    public void writeKey(PageCursor cursor, LocalTimeIndexKey key) {
        cursor.putLong(key.nanoOfDay);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, LocalTimeIndexKey into, int keySize) {
        into.nanoOfDay = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

