/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.values.storable.ValueGroup;

public class TemporalIndexPopulatingUpdater
extends TemporalIndexCache<IndexUpdater>
implements IndexUpdater {
    TemporalIndexPopulatingUpdater(TemporalIndexPopulator populator, NodePropertyAccessor nodePropertyAccessor) {
        super(new PartFactory(populator, nodePropertyAccessor));
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.select(update.values()[0].valueGroup())).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.select(update.beforeValues()[0].valueGroup());
                IndexUpdater to = (IndexUpdater)this.select(update.values()[0].valueGroup());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.select(update.values()[0].valueGroup())).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IndexEntryConflictException {
        for (IndexUpdater part : this) {
            part.close();
        }
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<IndexUpdater> {
        private final TemporalIndexPopulator populator;
        private NodePropertyAccessor nodePropertyAccessor;

        PartFactory(TemporalIndexPopulator populator, NodePropertyAccessor nodePropertyAccessor) {
            this.populator = populator;
            this.nodePropertyAccessor = nodePropertyAccessor;
        }

        @Override
        public IndexUpdater newDate() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.DATE)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newLocalDateTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.LOCAL_DATE_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newZonedDateTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.ZONED_DATE_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newLocalTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.LOCAL_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newZonedTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.ZONED_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newDuration() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.DURATION)).newPopulatingUpdater(this.nodePropertyAccessor);
        }
    }
}

