/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.ExplicitIndexProgressor;
import org.neo4j.kernel.impl.newapi.LockingNodeUniqueIndexSeek;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexProgressor;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
ExplicitIndexRead,
SchemaRead,
Procedures,
Locks,
AssertOpen,
LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker<DefaultNodeValueIndexCursor> {
    private final DefaultCursors cursors;
    final KernelTransactionImplementation ktx;

    Read(DefaultCursors cursors, KernelTransactionImplementation ktx) {
        this.cursors = cursors;
        this.ktx = ktx;
    }

    public final void nodeIndexSeek(IndexReference index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
        this.ktx.assertOpen();
        if (this.hasForbiddenProperties(index)) {
            cursor.close();
            return;
        }
        DefaultNodeValueIndexCursor cursorImpl = (DefaultNodeValueIndexCursor)cursor;
        IndexReader reader = this.indexReader(index, false);
        cursorImpl.setRead(this, null);
        IndexProgressor.NodeValueClient withFullPrecision = this.injectFullValuePrecision(cursorImpl, query, reader);
        reader.query(withFullPrecision, indexOrder, needsValues, query);
    }

    private IndexProgressor.NodeValueClient injectFullValuePrecision(IndexProgressor.NodeValueClient cursor, IndexQuery[] query, IndexReader reader) {
        IndexProgressor.NodeValueClient target = cursor;
        if (!reader.hasFullValuePrecision(query)) {
            IndexQuery[] filters = new IndexQuery[query.length];
            int count = 0;
            block4: for (int i = 0; i < query.length; ++i) {
                IndexQuery q = query[i];
                switch (q.type()) {
                    case range: {
                        ValueGroup valueGroup = q.valueGroup();
                        if (valueGroup != ValueGroup.NUMBER && valueGroup != ValueGroup.GEOMETRY || reader.hasFullValuePrecision(new IndexQuery[]{q})) continue block4;
                        filters[i] = q;
                        ++count;
                        continue block4;
                    }
                    case exact: {
                        Value value = ((IndexQuery.ExactPredicate)q).value();
                        if (value.valueGroup() != ValueGroup.NUMBER && !Values.isArrayValue((Value)value) && value.valueGroup() != ValueGroup.GEOMETRY || reader.hasFullValuePrecision(new IndexQuery[]{q})) continue block4;
                        filters[i] = q;
                        ++count;
                        continue block4;
                    }
                }
            }
            if (count > 0) {
                target = new NodeValueClientFilter(target, this.cursors.allocateNodeCursor(), this.cursors.allocatePropertyCursor(), this, filters);
            }
        }
        return target;
    }

    public long lockingNodeUniqueIndexSeek(IndexReference index, IndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        Locks.Client locks = this.ktx.statementLocks().optimistic();
        LockTracer lockTracer = this.ktx.lockTracer();
        return LockingNodeUniqueIndexSeek.apply(locks, lockTracer, this.cursors::allocateNodeValueIndexCursor, this, index, predicates);
    }

    @Override
    public void nodeIndexSeekWithFreshIndexReader(IndexReference index, DefaultNodeValueIndexCursor cursor, IndexQuery.ExactPredicate ... query) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        IndexReader reader = this.indexReader(index, true);
        cursor.setRead(this, (Resource)reader);
        IndexProgressor.NodeValueClient target = this.injectFullValuePrecision(cursor, (IndexQuery[])query, reader);
        reader.query(target, IndexOrder.NONE, false, (IndexQuery[])query);
    }

    public final void nodeIndexScan(IndexReference index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues) throws KernelException {
        this.ktx.assertOpen();
        if (this.hasForbiddenProperties(index)) {
            cursor.close();
            return;
        }
        int firstProperty = index.properties()[0];
        DefaultNodeValueIndexCursor cursorImpl = (DefaultNodeValueIndexCursor)cursor;
        cursorImpl.setRead(this, null);
        this.indexReader(index, false).query((IndexProgressor.NodeValueClient)cursorImpl, indexOrder, needsValues, new IndexQuery[]{IndexQuery.exists((int)firstProperty)});
    }

    private boolean hasForbiddenProperties(IndexReference index) {
        AccessMode mode = this.ktx.securityContext().mode();
        for (int prop : index.properties()) {
            if (mode.allowsPropertyReads(prop)) continue;
            return true;
        }
        return false;
    }

    public final void nodeLabelScan(int label, NodeLabelIndexCursor cursor) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this);
        this.labelScanReader().nodesWithLabel((IndexProgressor.NodeLabelClient)indexCursor, label);
    }

    public void nodeLabelUnionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor client = (DefaultNodeLabelIndexCursor)cursor;
        client.setRead(this);
        client.unionScan(new NodeLabelIndexProgressor(this.labelScanReader().nodesWithAnyOfLabels(labels), client), false, labels);
    }

    public void nodeLabelIntersectionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor client = (DefaultNodeLabelIndexCursor)cursor;
        client.setRead(this);
        client.intersectionScan(new NodeLabelIndexProgressor(this.labelScanReader().nodesWithAllLabels(labels), client), false, labels);
    }

    public final Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void allNodesScan(NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).scan(this);
    }

    public final Scan<NodeCursor> allNodesScan() {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void singleNode(long reference, NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).single(reference, this);
    }

    public final void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this);
    }

    public final void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(-1, this);
    }

    public final Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void relationshipTypeScan(int type, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(type, this);
    }

    public final Scan<RelationshipScanCursor> relationshipTypeScan(int type) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public void relationshipGroups(long nodeReference, long reference, RelationshipGroupCursor cursor) {
        ((DefaultRelationshipGroupCursor)cursor).init(nodeReference, reference, this);
    }

    public void relationships(long nodeReference, long reference, RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, reference, this);
    }

    public void nodeProperties(long nodeReference, long reference, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, this, this.ktx);
    }

    public void relationshipProperties(long relationshipReference, long reference, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, this, this.ktx);
    }

    public final void graphProperties(PropertyCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultPropertyCursor)cursor).initGraph(this.graphPropertiesReference(), this, this.ktx);
    }

    abstract long graphPropertiesReference();

    public final void nodeExplicitIndexLookup(NodeExplicitIndexCursor cursor, String index, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ((DefaultNodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultNodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).get(key, value));
    }

    public final void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, Object query) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ((DefaultNodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultNodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).query(query instanceof Value ? ((Value)query).asObject() : query));
    }

    public final void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, String key, Object query) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ((DefaultNodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultNodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).query(key, query instanceof Value ? ((Value)query).asObject() : query));
    }

    public void relationshipExplicitIndexLookup(RelationshipExplicitIndexCursor cursor, String index, String key, Object value, long source, long target) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ((DefaultRelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultRelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).get(key, value, source, target));
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, Object query, long source, long target) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ((DefaultRelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultRelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).query(query instanceof Value ? ((Value)query).asObject() : query, source, target));
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, String key, Object query, long source, long target) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ((DefaultRelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultRelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).query(key, query instanceof Value ? ((Value)query).asObject() : query, source, target));
    }

    private static void explicitIndex(IndexProgressor.ExplicitClient client, ExplicitIndexHits hits) {
        client.initialize((IndexProgressor)new ExplicitIndexProgressor(hits, client), hits.size());
    }

    public final void futureNodeReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public final void futureRelationshipsReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public final void futureNodePropertyReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public final void futureRelationshipPropertyReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public abstract IndexReader indexReader(IndexReference var1, boolean var2) throws IndexNotFoundKernelException;

    abstract LabelScanReader labelScanReader();

    abstract ExplicitIndex explicitNodeIndex(String var1) throws ExplicitIndexNotFoundKernelException;

    abstract ExplicitIndex explicitRelationshipIndex(String var1) throws ExplicitIndexNotFoundKernelException;

    public abstract IndexReference index(int var1, int ... var2);

    @Override
    public TransactionState txState() {
        return this.ktx.txState();
    }

    @Override
    public AuxiliaryTransactionState auxiliaryTxState(Object providerIdentityKey) {
        return this.ktx.auxiliaryTxState(providerIdentityKey);
    }

    @Override
    public ExplicitIndexTransactionState explicitIndexTxState() {
        return this.ktx.explicitIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.ktx.hasTxStateWithChanges();
    }

    public void acquireExclusiveNodeLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveRelationshipLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveExplicitIndexLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveLabelLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveExplicitIndexLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveLabelLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedNodeLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedRelationshipLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedExplicitIndexLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedLabelLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedExplicitIndexLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedLabelLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    void acquireSharedSchemaLock(SchemaDescriptor schema) {
        long[] lockingIds = SchemaDescriptor.schemaTokenLockingIds((SchemaDescriptor)schema);
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), schema.keyType(), lockingIds);
    }

    void acquireSharedLock(ResourceType resource, long resourceId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), resource, resourceId);
    }

    private void acquireExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().acquireExclusive(this.ktx.lockTracer(), types, ids);
    }

    private void releaseExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().releaseExclusive(types, ids);
    }

    private void acquireSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().acquireShared(this.ktx.lockTracer(), types, ids);
    }

    private void releaseSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().releaseShared(types, ids);
    }

    private void assertIndexOnline(IndexReference index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.indexGetState(index)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.indexGetFailure(index));
    }

    private static void assertPredicatesMatchSchema(IndexReference index, IndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.properties();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    @Override
    public void assertOpen() {
        this.ktx.assertOpen();
    }
}

