/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;

class GraphDatabaseSettingsTest {
    GraphDatabaseSettingsTest() {
    }

    @Test
    void mustHaveNullDefaultPageCacheMemorySizeInBytes() {
        String bytes = (String)Config.defaults().get(GraphDatabaseSettings.pagecache_memory);
        MatcherAssert.assertThat((Object)bytes, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    void pageCacheSettingMustAcceptArbitraryUserSpecifiedValue() {
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        MatcherAssert.assertThat((Object)Config.defaults((Setting)setting, (String)"245760").get(setting), (Matcher)Matchers.is((Object)"245760"));
        MatcherAssert.assertThat((Object)Config.defaults((Setting)setting, (String)"2244g").get(setting), (Matcher)Matchers.is((Object)"2244g"));
        MatcherAssert.assertThat((Object)Config.defaults((Setting)setting, (String)"string").get(setting), (Matcher)Matchers.is((Object)"string"));
    }

    @Test
    void noDuplicateSettingsAreAllowed() throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Field field : GraphDatabaseSettings.class.getDeclaredFields()) {
            if (field.getType() != Setting.class) continue;
            Setting setting = (Setting)field.get(null);
            Assertions.assertFalse((boolean)fields.containsKey(setting.name()), (String)String.format("'%s' in %s has already been defined in %s", setting.name(), field.getName(), fields.get(setting.name())));
            fields.put(setting.name(), field.getName());
        }
    }

    @Test
    void groupToScopeSetting() {
        String hostname = "my_other_host";
        int port = 9999;
        String scoping = "bla";
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_advertised_address.name(), hostname, new BoltConnector((String)scoping).advertised_address.name(), ":" + port});
        BoltConnector boltConnector = new BoltConnector(scoping);
        Setting advertisedAddress = boltConnector.advertised_address;
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)advertisedAddress.apply(config::get);
        Assertions.assertEquals((Object)hostname, (Object)advertisedSocketAddress.getHostname());
        Assertions.assertEquals((int)port, (int)advertisedSocketAddress.getPort());
    }

    @Test
    void shouldEnableBoltByDefault() {
        Config config = Config.builder().withServerDefaults().build();
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        ListenSocketAddress listenSocketAddress = (ListenSocketAddress)config.get(boltConnector.listen_address);
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 7687), (Object)listenSocketAddress);
    }

    @Test
    void shouldBeAbleToDisableBoltConnectorWithJustOneParameter() {
        Config config = Config.defaults((Setting)new BoltConnector((String)"bolt").enabled, (String)"false");
        MatcherAssert.assertThat((Object)config.boltConnectors().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)config.enabledBoltConnectors(), (Matcher)Matchers.empty());
    }

    @Test
    void shouldBeAbleToOverrideBoltListenAddressesWithJustOneParameter() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true", "dbms.connector.bolt.listen_address", ":8000"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    void shouldDeriveBoltListenAddressFromDefaultListenAddress() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true", "dbms.connectors.default_listen_address", "0.0.0.0"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assertions.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 7687), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    void shouldDeriveBoltListenAddressFromDefaultListenAddressAndSpecifiedPort() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connectors.default_listen_address", "0.0.0.0", "dbms.connector.bolt.enabled", "true", "dbms.connector.bolt.listen_address", ":8000"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assertions.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    void shouldStillSupportCustomNameForBoltConnector() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "BOLT", "dbms.connector.random_name_that_will_be_unsupported.enabled", "true", "dbms.connector.random_name_that_will_be_unsupported.listen_address", ":8000"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    void shouldSupportMultipleBoltConnectorsWithCustomNames() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt1.type", "BOLT", "dbms.connector.bolt1.enabled", "true", "dbms.connector.bolt1.listen_address", ":8000", "dbms.connector.bolt2.type", "BOLT", "dbms.connector.bolt2.enabled", "true", "dbms.connector.bolt2.listen_address", ":9000"}));
        List addresses = config.boltConnectors().stream().map(c -> (ListenSocketAddress)config.get(c.listen_address)).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)addresses.size());
        if (((ListenSocketAddress)addresses.get(0)).getPort() == 8000) {
            Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), addresses.get(0));
            Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), addresses.get(1));
        } else {
            Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), addresses.get(1));
            Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), addresses.get(0));
        }
    }

    @Test
    void shouldSupportMultipleBoltConnectorsWithDefaultAndCustomName() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.type", "BOLT", "dbms.connector.bolt.enabled", "true", "dbms.connector.bolt.listen_address", ":8000", "dbms.connector.bolt2.type", "BOLT", "dbms.connector.bolt2.enabled", "true", "dbms.connector.bolt2.listen_address", ":9000"}));
        BoltConnector boltConnector1 = (BoltConnector)config.boltConnectors().get(0);
        BoltConnector boltConnector2 = (BoltConnector)config.boltConnectors().get(1);
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(boltConnector1.listen_address));
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), (Object)config.get(boltConnector2.listen_address));
    }

    @Test
    void testServerDefaultSettings() {
        Config config = Config.builder().withServerDefaults().build();
        List connectors = config.httpConnectors();
        Assertions.assertEquals((int)2, (int)connectors.size());
        if (((HttpConnector)connectors.get(0)).encryptionLevel().equals((Object)HttpConnector.Encryption.TLS)) {
            Assertions.assertEquals((Object)new ListenSocketAddress("localhost", 7474), (Object)config.get(((HttpConnector)connectors.get((int)1)).listen_address));
            Assertions.assertEquals((Object)new ListenSocketAddress("localhost", 7473), (Object)config.get(((HttpConnector)connectors.get((int)0)).listen_address));
        } else {
            Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 7474), (Object)config.get(((HttpConnector)connectors.get((int)0)).listen_address));
            Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 7473), (Object)config.get(((HttpConnector)connectors.get((int)1)).listen_address));
        }
    }

    @Test
    void shouldBeAbleToDisableHttpConnectorWithJustOneParameter() {
        Config disableHttpConfig = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.http.enabled", "false", "dbms.connector.https.enabled", "false"}));
        Assertions.assertTrue((boolean)disableHttpConfig.enabledHttpConnectors().isEmpty());
        Assertions.assertEquals((int)2, (int)disableHttpConfig.httpConnectors().size());
    }

    @Test
    void shouldBeAbleToOverrideHttpListenAddressWithJustOneParameter() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.http.enabled", "true", "dbms.connector.http.listen_address", ":8000"}));
        Assertions.assertEquals((int)1, (int)config.enabledHttpConnectors().size());
        HttpConnector httpConnector = (HttpConnector)config.enabledHttpConnectors().get(0);
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(httpConnector.listen_address));
    }

    @Test
    void hasDefaultBookmarkAwaitTimeout() {
        Config config = Config.defaults();
        long bookmarkReadyTimeoutMs = ((Duration)config.get(GraphDatabaseSettings.bookmark_ready_timeout)).toMillis();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(30L), (long)bookmarkReadyTimeoutMs);
    }

    @Test
    void shouldBeAbleToOverrideHttpsListenAddressWithJustOneParameter() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.https.enabled", "true", "dbms.connector.https.listen_address", ":8000"}));
        Assertions.assertEquals((int)1, (int)config.enabledHttpConnectors().size());
        HttpConnector httpConnector = (HttpConnector)config.enabledHttpConnectors().get(0);
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(httpConnector.listen_address));
    }

    @Test
    void throwsForIllegalBookmarkAwaitTimeout() {
        String[] illegalValues;
        for (String value : illegalValues = new String[]{"0ms", "0s", "10ms", "99ms", "999ms", "42ms"}) {
            Assertions.assertThrows(InvalidSettingException.class, () -> {
                Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.bookmark_ready_timeout.name(), value}));
                config.get(GraphDatabaseSettings.bookmark_ready_timeout);
            }, (String)("Exception expected for value '" + value + "'"));
        }
    }

    @Test
    void shouldDeriveListenAddressFromDefaultListenAddress() {
        Config config = Config.fromSettings((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.https.enabled", "true", "dbms.connector.http.enabled", "true", "dbms.connectors.default_listen_address", "0.0.0.0"})).withServerDefaults().build();
        Assertions.assertEquals((int)2, (int)config.enabledHttpConnectors().size());
        config.enabledHttpConnectors().forEach(c -> Assertions.assertEquals((Object)"0.0.0.0", (Object)((ListenSocketAddress)config.get(c.listen_address)).getHostname()));
    }

    @Test
    void shouldDeriveListenAddressFromDefaultListenAddressAndSpecifiedPorts() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.https.enabled", "true", "dbms.connector.http.enabled", "true", "dbms.connectors.default_listen_address", "0.0.0.0", "dbms.connector.http.listen_address", ":8000", "dbms.connector.https.listen_address", ":9000"}));
        Assertions.assertEquals((int)2, (int)config.enabledHttpConnectors().size());
        config.enabledHttpConnectors().forEach(c -> {
            if (c.key().equals("https")) {
                Assertions.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 9000), (Object)config.get(c.listen_address));
            } else {
                Assertions.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 8000), (Object)config.get(c.listen_address));
            }
        });
    }

    @Test
    void shouldStillSupportCustomNameForHttpConnector() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "HTTP", "dbms.connector.random_name_that_will_be_unsupported.encryption", "NONE", "dbms.connector.random_name_that_will_be_unsupported.enabled", "true", "dbms.connector.random_name_that_will_be_unsupported.listen_address", ":8000"}));
        Assertions.assertEquals((int)1, (int)config.enabledHttpConnectors().size());
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(((HttpConnector)config.enabledHttpConnectors().get((int)0)).listen_address));
    }

    @Test
    void shouldStillSupportCustomNameForHttpsConnector() {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "HTTP", "dbms.connector.random_name_that_will_be_unsupported.encryption", "TLS", "dbms.connector.random_name_that_will_be_unsupported.enabled", "true", "dbms.connector.random_name_that_will_be_unsupported.listen_address", ":9000"}));
        Assertions.assertEquals((int)1, (int)config.enabledHttpConnectors().size());
        Assertions.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), (Object)config.get(((HttpConnector)config.enabledHttpConnectors().get((int)0)).listen_address));
    }

    @Test
    void validateRetentionPolicy() {
        String[] validSet = new String[]{"true", "keep_all", "false", "keep_none", "10 files", "10k files", "10K size", "10m txs", "10M entries", "10g hours", "10G days"};
        String[] invalidSet = new String[]{"invalid", "all", "10", "10k", "10k a"};
        for (String valid : validSet) {
            Assertions.assertEquals((Object)valid, (Object)Config.defaults((Setting)GraphDatabaseSettings.keep_logical_logs, (String)valid).get(GraphDatabaseSettings.keep_logical_logs));
        }
        for (String invalid : invalidSet) {
            Assertions.assertThrows(InvalidSettingException.class, () -> Config.defaults((Setting)GraphDatabaseSettings.keep_logical_logs, (String)invalid), (String)("Value \"" + invalid + "\" should be considered invalid"));
        }
    }
}

