/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.time.Clocks;

public class DatabaseAvailabilityGuardTest {
    private static final AvailabilityRequirement REQUIREMENT_1 = new DescriptiveAvailabilityRequirement("Requirement 1");
    private static final AvailabilityRequirement REQUIREMENT_2 = new DescriptiveAvailabilityRequirement("Requirement 2");
    private final Clock clock = Clocks.systemClock();

    @Test
    public void logOnAvailabilityChange() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        Mockito.verifyZeroInteractions((Object[])new Object[]{log});
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        DatabaseAvailabilityGuardTest.verifyLogging(log, Mockito.atLeastOnce());
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        DatabaseAvailabilityGuardTest.verifyLogging(log, Mockito.times((int)4));
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        DatabaseAvailabilityGuardTest.verifyLogging(log, Mockito.times((int)6));
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        DatabaseAvailabilityGuardTest.verifyLogging(log, Mockito.times((int)6));
        databaseAvailabilityGuard.fulfill(REQUIREMENT_2);
        DatabaseAvailabilityGuardTest.verifyLogging(log, Mockito.times((int)8));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenAwaitThenTimeoutAndReturnFalse() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        boolean result = databaseAvailabilityGuard.isAvailable(1000L);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenAwaitThenActuallyWaitGivenTimeout() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        long timeout = 1000L;
        long start = this.clock.millis();
        boolean result = databaseAvailabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)waitTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitThenTimeoutAndReturnFalse() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        long start = this.clock.millis();
        long timeout = 1000L;
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        boolean result = databaseAvailabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)waitTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantEachAndAwaitThenTrue() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_2);
        Assert.assertTrue((boolean)databaseAvailabilityGuard.isAvailable(1000L));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantTwiceAndDenyOnceAndAwaitThenTimeoutAndReturnFalse() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        long start = this.clock.millis();
        long timeout = 1000L;
        boolean result = databaseAvailabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)waitTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitAndGrantAgainThenReturnTrue() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_2);
        Assert.assertFalse((boolean)databaseAvailabilityGuard.isAvailable(100L));
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        Assert.assertTrue((boolean)databaseAvailabilityGuard.isAvailable(100L));
    }

    @Test
    public void givenAccessGuardWithConditionWhenGrantThenNotifyListeners() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityListener availabilityListener = new AvailabilityListener(){

            public void available() {
                notified.set(true);
            }

            public void unavailable() {
            }
        };
        databaseAvailabilityGuard.addListener(availabilityListener);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        Assert.assertThat((Object)notified.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void givenAccessGuardWithConditionWhenGrantAndDenyThenNotifyListeners() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityListener availabilityListener = new AvailabilityListener(){

            public void available() {
            }

            public void unavailable() {
                notified.set(true);
            }
        };
        databaseAvailabilityGuard.addListener(availabilityListener);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        Assert.assertThat((Object)notified.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void givenAccessGuardWithConditionWhenShutdownThenInstantlyDenyAccess() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(clock, (Log)NullLog.getInstance());
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.shutdown();
        Assert.assertFalse((boolean)databaseAvailabilityGuard.isAvailable(1000L));
        Mockito.verifyZeroInteractions((Object[])new Object[]{clock});
    }

    @Test
    public void shouldExplainWhoIsBlockingAccess() {
        Log log = (Log)Mockito.mock(Log.class);
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(this.clock, log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        Assert.assertThat((Object)databaseAvailabilityGuard.describeWhoIsBlocking(), (Matcher)CoreMatchers.equalTo((Object)"2 reasons for blocking: Requirement 1, Requirement 2."));
    }

    @Test
    public void shouldExplainBlockersOnCheckAvailable() throws Exception {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = DatabaseAvailabilityGuardTest.getDatabaseAvailabilityGuard(Clocks.systemClock(), (Log)NullLog.getInstance());
        databaseAvailabilityGuard.checkAvailable();
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        try {
            databaseAvailabilityGuard.checkAvailable();
            Assert.fail((String)"Should not be available");
        }
        catch (UnavailableException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)REQUIREMENT_1.description()));
        }
    }

    private static void verifyLogging(Log log, VerificationMode mode) {
        ((Log)Mockito.verify((Object)log, (VerificationMode)mode)).info(ArgumentMatchers.anyString(), (Object[])Mockito.anyVararg());
    }

    private static DatabaseAvailabilityGuard getDatabaseAvailabilityGuard(Clock clock, Log log) {
        return new DatabaseAvailabilityGuard("graph.db", clock, log);
    }
}

