/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;

public class SchemaProcessorTest {
    private static final int LABEL_ID = 0;
    private static final int REL_TYPE_ID = 0;

    @Test
    public void shouldHandleCorrectDescriptorVersions() {
        final ArrayList callHistory = new ArrayList();
        SchemaProcessor processor = new SchemaProcessor(){

            public void processSpecific(LabelSchemaDescriptor schema) {
                callHistory.add("LabelSchemaDescriptor");
            }

            public void processSpecific(RelationTypeSchemaDescriptor schema) {
                callHistory.add("RelationTypeSchemaDescriptor");
            }

            public void processSpecific(SchemaDescriptor schemaDescriptor) {
                callHistory.add("SchemaDescriptor");
            }
        };
        this.disguisedLabel().processWith(processor);
        this.disguisedLabel().processWith(processor);
        this.disguisedRelType().processWith(processor);
        this.disguisedLabel().processWith(processor);
        this.disguisedRelType().processWith(processor);
        this.disguisedRelType().processWith(processor);
        MatcherAssert.assertThat(callHistory, (Matcher)Matchers.contains((Object[])new String[]{"LabelSchemaDescriptor", "LabelSchemaDescriptor", "RelationTypeSchemaDescriptor", "LabelSchemaDescriptor", "RelationTypeSchemaDescriptor", "RelationTypeSchemaDescriptor"}));
    }

    private SchemaDescriptor disguisedLabel() {
        return SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
    }

    private SchemaDescriptor disguisedRelType() {
        return SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1});
    }
}

