/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;

public class SchemaIndexDescriptorFactoryTest {
    private static final int LABEL_ID = 0;

    @Test
    public void shouldCreateIndexDescriptors() {
        IndexDescriptor desc = TestIndexDescriptorFactory.forLabel(0, 1);
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.GENERAL));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateUniqueIndexDescriptors() {
        IndexDescriptor desc = TestIndexDescriptorFactory.uniqueForLabel(0, 1);
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateIndexDescriptorsFromSchema() {
        IndexDescriptor desc = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.GENERAL));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        desc = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateEqualDescriptors() {
        IndexDescriptor desc1 = TestIndexDescriptorFactory.forLabel(0, 1);
        IndexDescriptor desc2 = TestIndexDescriptorFactory.forLabel(0, 1);
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = TestIndexDescriptorFactory.uniqueForLabel(0, 1);
        desc2 = TestIndexDescriptorFactory.uniqueForLabel(0, 1);
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    public void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)TestIndexDescriptorFactory.forLabel(1, 2).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Index( GENERAL, :Label1(property2) )"));
        MatcherAssert.assertThat((Object)TestIndexDescriptorFactory.uniqueForLabel(2, 4).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Index( UNIQUE, :Label2(property4) )"));
    }
}

