/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txtracking;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.txtracking.TransactionIdTracker;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionIdTrackerTest {
    private static final Duration DEFAULT_DURATION = Duration.ofSeconds(10L);
    private final TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final AvailabilityGuard databaseAvailabilityGuard = (AvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
    private TransactionIdTracker transactionIdTracker;

    @Before
    public void setup() {
        Mockito.when((Object)this.databaseAvailabilityGuard.isAvailable()).thenReturn((Object)true);
        this.transactionIdTracker = new TransactionIdTracker(() -> this.transactionIdStore, this.databaseAvailabilityGuard);
    }

    @Test
    public void shouldReturnImmediatelyForBaseTxIdOrLess() throws Exception {
        this.transactionIdTracker.awaitUpToDate(1L, Duration.ofSeconds(5L));
        ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.never())).awaitClosedTransactionId(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldWaitForRequestedVersion() throws Exception {
        long version = 5L;
        this.transactionIdTracker.awaitUpToDate(version, DEFAULT_DURATION);
        ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore)).awaitClosedTransactionId(version, DEFAULT_DURATION.toMillis());
    }

    @Test
    public void shouldPropagateTimeoutException() throws Exception {
        long version = 5L;
        TimeoutException timeoutException = new TimeoutException();
        ((TransactionIdStore)Mockito.doThrow((Throwable[])new Throwable[]{timeoutException}).when((Object)this.transactionIdStore)).awaitClosedTransactionId(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        try {
            this.transactionIdTracker.awaitUpToDate(version + 1L, Duration.ofMillis(50L));
            Assert.fail((String)"should have thrown");
        }
        catch (TransactionFailureException ex) {
            Assert.assertEquals((Object)Status.Transaction.InstanceStateChanged, (Object)ex.status());
            Assert.assertEquals((Object)timeoutException, (Object)ex.getCause());
        }
    }

    @Test
    public void shouldNotWaitIfTheDatabaseIsUnavailable() throws Exception {
        Mockito.when((Object)this.databaseAvailabilityGuard.isAvailable()).thenReturn((Object)false);
        try {
            this.transactionIdTracker.awaitUpToDate(1000L, Duration.ofMillis(60000L));
            Assert.fail((String)"should have thrown");
        }
        catch (TransactionFailureException ex) {
            Assert.assertEquals((Object)Status.General.DatabaseUnavailable, (Object)ex.status());
        }
        ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.never())).awaitClosedTransactionId(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldReturnNewestTransactionId() {
        Mockito.when((Object)this.transactionIdStore.getLastClosedTransactionId()).thenReturn((Object)42L);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)4242L);
        Assert.assertEquals((long)4242L, (long)this.transactionIdTracker.newestEncounteredTxId());
    }
}

