/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.ExplicitBatchIndexApplier;
import org.neo4j.kernel.impl.api.ExplicitIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.FakeCommitment;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.Race;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ExplicitBatchIndexApplierTest {
    private final LifeRule life = new LifeRule(true);
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.testDirectory).around((TestRule)this.life);

    @Test
    public void shouldOnlyCreateOneApplierPerProvider() throws Exception {
        ObjectIntHashMap names = ObjectIntHashMap.newWithKeysValues((Object)"first", (int)0, (Object)"second", (int)1);
        ObjectIntHashMap keys = ObjectIntHashMap.newWithKeysValues((Object)"key", (int)0);
        String applierName = "test-applier";
        Commitment commitment = (Commitment)Mockito.mock(Commitment.class);
        Mockito.when((Object)commitment.hasExplicitIndexChanges()).thenReturn((Object)true);
        IndexConfigStore config = this.newIndexConfigStore((MutableObjectIntMap<String>)names, applierName);
        ExplicitIndexApplierLookup applierLookup = (ExplicitIndexApplierLookup)Mockito.mock(ExplicitIndexApplierLookup.class);
        TransactionApplier transactionApplier = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        Mockito.when((Object)applierLookup.newApplier(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn((Object)transactionApplier);
        try (ExplicitBatchIndexApplier applier = new ExplicitBatchIndexApplier(config, applierLookup, IdOrderingQueue.BYPASS, TransactionApplicationMode.INTERNAL);){
            TransactionToApply tx = new TransactionToApply(null, 2L);
            tx.commitment(commitment, 2L);
            try (TransactionApplier txApplier = applier.startTx((CommandsToApply)tx);){
                IndexDefineCommand definitions = ExplicitBatchIndexApplierTest.definitions((MutableObjectIntMap<String>)names, (MutableObjectIntMap<String>)keys);
                txApplier.visitIndexDefineCommand(definitions);
                txApplier.visitIndexAddNodeCommand(ExplicitBatchIndexApplierTest.addNodeToIndex(definitions, "first"));
                txApplier.visitIndexAddNodeCommand(ExplicitBatchIndexApplierTest.addNodeToIndex(definitions, "second"));
                txApplier.visitIndexAddRelationshipCommand(ExplicitBatchIndexApplierTest.addRelationshipToIndex(definitions, "second"));
            }
        }
        ((ExplicitIndexApplierLookup)Mockito.verify((Object)applierLookup, (VerificationMode)Mockito.times((int)1))).newApplier((String)ArgumentMatchers.eq((Object)applierName), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldOrderTransactionsMakingExplicitIndexChanges() throws Throwable {
        ObjectIntHashMap names = ObjectIntHashMap.newWithKeysValues((Object)"first", (int)0, (Object)"second", (int)1);
        ObjectIntHashMap keys = ObjectIntHashMap.newWithKeysValues((Object)"key", (int)0);
        String applierName = "test-applier";
        ExplicitIndexApplierLookup applierLookup = (ExplicitIndexApplierLookup)Mockito.mock(ExplicitIndexApplierLookup.class);
        TransactionApplier transactionApplier = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        Mockito.when((Object)applierLookup.newApplier(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn((Object)transactionApplier);
        IndexConfigStore config = this.newIndexConfigStore((MutableObjectIntMap<String>)names, applierName);
        SynchronizedArrayIdOrderingQueue queue = new SynchronizedArrayIdOrderingQueue();
        AtomicLong lastAppliedTxId = new AtomicLong(-1L);
        Race race = new Race();
        long i = 0L;
        while (i < 100L) {
            long txId = i++;
            race.addContestant(() -> {
                try (ExplicitBatchIndexApplier applier = new ExplicitBatchIndexApplier(config, applierLookup, (IdOrderingQueue)queue, TransactionApplicationMode.INTERNAL);){
                    TransactionToApply txToApply = new TransactionToApply((TransactionRepresentation)new PhysicalTransactionRepresentation(new ArrayList()));
                    FakeCommitment commitment = new FakeCommitment(txId, (TransactionIdStore)Mockito.mock(TransactionIdStore.class));
                    commitment.setHasExplicitIndexChanges(true);
                    txToApply.commitment((Commitment)commitment, txId);
                    TransactionApplier txApplier = applier.startTx((CommandsToApply)txToApply);
                    Thread.sleep(ThreadLocalRandom.current().nextInt(5));
                    Assert.assertTrue((boolean)lastAppliedTxId.compareAndSet(txId - 1L, txId));
                    txApplier.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            queue.offer(txId);
        }
        race.go();
    }

    private static IndexCommand.AddRelationshipCommand addRelationshipToIndex(IndexDefineCommand definitions, String indexName) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), 0L, 0, null, 1L, 2L);
        return command;
    }

    private static IndexCommand.AddNodeCommand addNodeToIndex(IndexDefineCommand definitions, String indexName) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), 0L, 0, null);
        return command;
    }

    private static IndexDefineCommand definitions(MutableObjectIntMap<String> names, MutableObjectIntMap<String> keys) {
        IndexDefineCommand definitions = new IndexDefineCommand();
        definitions.init(names, keys);
        return definitions;
    }

    private IndexConfigStore newIndexConfigStore(MutableObjectIntMap<String> names, String providerName) {
        EphemeralFileSystemAbstraction fileSystem = (EphemeralFileSystemAbstraction)this.fs.get();
        IndexConfigStore store = (IndexConfigStore)this.life.add((Lifecycle)new IndexConfigStore(this.testDirectory.databaseLayout(), (FileSystemAbstraction)fileSystem));
        names.forEachKey((Procedure & Serializable)name -> {
            store.set(Node.class, name, MapUtil.stringMap((String[])new String[]{"provider", providerName}));
            store.set(Relationship.class, name, MapUtil.stringMap((String[])new String[]{"provider", providerName}));
        });
        return store;
    }
}

