/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.function.IntPredicate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexPopulationTest {
    @Test
    public void mustFlipToFailedIfFailureToApplyLastBatchWhileFlipping() throws Exception {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexStoreView.Adaptor storeView = this.emptyIndexStoreViewThatProcessUpdates();
        IndexPopulator.Adapter populator = this.emptyPopulatorWithThrowingUpdater();
        FailedIndexProxy failedProxy = this.failedIndexProxy((IndexStoreView)storeView, populator);
        OnlineIndexProxy onlineProxy = this.onlineIndexProxy((IndexStoreView)storeView);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(() -> onlineProxy);
        MultipleIndexPopulator multipleIndexPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, (LogProvider)logProvider, EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class));
        MultipleIndexPopulator.IndexPopulation indexPopulation = multipleIndexPopulator.addPopulator((IndexPopulator)populator, this.dummyMeta(), flipper, t -> failedProxy, "userDescription");
        multipleIndexPopulator.queueUpdate(this.someUpdate());
        multipleIndexPopulator.indexAllEntities().run();
        indexPopulation.flip(false);
        Assert.assertSame((String)"flipper should have flipped to failing proxy", (Object)flipper.getState(), (Object)InternalIndexState.FAILED);
    }

    private OnlineIndexProxy onlineIndexProxy(IndexStoreView storeView) {
        return new OnlineIndexProxy(this.dummyMeta(), IndexAccessor.EMPTY, storeView, false);
    }

    private FailedIndexProxy failedIndexProxy(IndexStoreView storeView, IndexPopulator.Adapter populator) {
        return new FailedIndexProxy(this.dummyMeta(), "userDescription", (IndexPopulator)populator, IndexPopulationFailure.failure((String)"failure"), new IndexCountsRemover(storeView, 0L), (LogProvider)NullLogProvider.getInstance());
    }

    private IndexPopulator.Adapter emptyPopulatorWithThrowingUpdater() {
        return new IndexPopulator.Adapter(){

            public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
                return new IndexUpdater(){

                    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                        throw new IndexEntryConflictException(0L, 1L, new Value[]{Values.numberValue((Number)0)});
                    }

                    public void close() {
                    }
                };
            }
        };
    }

    private IndexStoreView.Adaptor emptyIndexStoreViewThatProcessUpdates() {
        return new IndexStoreView.Adaptor(){

            public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
                return new StoreScan(){

                    public void run() {
                    }

                    public void stop() {
                    }

                    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate update, long currentlyIndexedNodeId) {
                        if (update.getEntityId() <= currentlyIndexedNodeId) {
                            updater.process(update);
                        }
                    }

                    public PopulationProgress getProgress() {
                        return null;
                    }
                };
            }
        };
    }

    private CapableIndexDescriptor dummyMeta() {
        return TestIndexDescriptorFactory.forLabel(0, 0).withId(0L).withoutCapabilities();
    }

    private IndexEntryUpdate<LabelSchemaDescriptor> someUpdate() {
        return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), (Value[])new Value[]{Values.numberValue((Number)0)});
    }
}

