/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class DefaultNonUniqueIndexSamplerTest {
    private final String value = "aaa";

    @Test
    public void shouldSampleNothing() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(10);
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 0L, 0L, 0L);
    }

    @Test
    public void shouldSampleASingleValue() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(10);
        sampler.include("aaa", 2L);
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 2L, 1L, 2L);
    }

    @Test
    public void shouldSampleDuplicateValues() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(10);
        sampler.include("aaa", 5L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 3L);
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 12L, 2L, 12L);
    }

    @Test
    public void shouldDivideTheSamplingInStepsNotBiggerThanBatchSize() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(1);
        sampler.include("aaa", 5L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 3L);
        int expectedSampledSize = 4;
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 12L, 1L, expectedSampledSize);
    }

    @Test
    public void shouldExcludeValuesFromTheCurrentSampling1() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(10);
        sampler.include("aaa", 5L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 3L);
        sampler.exclude("aaa", 3L);
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 9L, 2L, 9L);
    }

    @Test
    public void shouldExcludeValuesFromTheCurrentSampling2() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(10);
        sampler.include("aaa", 1L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 1L);
        sampler.exclude("aaa", 4L);
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 2L, 2L, 2L);
    }

    @Test
    public void shouldDoNothingWhenExcludingAValueInAnEmptySample() {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(10);
        sampler.exclude("aaa", 1L);
        sampler.include("aaa", 1L);
        this.assertSampledValues((NonUniqueIndexSampler)sampler, 1L, 1L, 1L);
    }

    private void assertSampledValues(NonUniqueIndexSampler sampler, long expectedIndexSize, long expectedUniqueValues, long expectedSampledSize) {
        IndexSample sample = sampler.result();
        Assert.assertEquals((long)expectedIndexSize, (long)sample.indexSize());
        Assert.assertEquals((long)expectedUniqueValues, (long)sample.uniqueValues());
        Assert.assertEquals((long)expectedSampledSize, (long)sample.sampleSize());
    }
}

