/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class OnlineIndexSamplingJobTest {
    private final LogProvider logProvider = NullLogProvider.getInstance();
    private final long indexId = 1L;
    private final IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexStoreView indexStoreView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final CapableIndexDescriptor indexDescriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2}), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withId(1L).withoutCapabilities();
    private final IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
    private final IndexSampler indexSampler = (IndexSampler)Mockito.mock(IndexSampler.class);
    private final long indexUniqueValues = 21L;
    private final long indexSize = 23L;

    @Test
    public void shouldSampleTheIndexAndStoreTheValueWhenTheIndexIsOnline() {
        OnlineIndexSamplingJob job = new OnlineIndexSamplingJob(1L, this.indexProxy, this.indexStoreView, "Foo", this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        job.run();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).replaceIndexCounts(1L, 21L, 23L, 23L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexStoreView});
    }

    @Test
    public void shouldSampleTheIndexButDoNotStoreTheValuesIfTheIndexIsNotOnline() {
        OnlineIndexSamplingJob job = new OnlineIndexSamplingJob(1L, this.indexProxy, this.indexStoreView, "Foo", this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.FAILED);
        job.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexStoreView});
    }

    @Before
    public void setup() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.indexProxy.getDescriptor()).thenReturn((Object)this.indexDescriptor);
        Mockito.when((Object)this.indexProxy.newReader()).thenReturn((Object)this.indexReader);
        Mockito.when((Object)this.indexReader.createSampler()).thenReturn((Object)this.indexSampler);
        Mockito.when((Object)this.indexSampler.sampleIndex()).thenReturn((Object)new IndexSample(23L, 21L, 23L));
    }
}

