/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.state.ExplicitIndexTransactionStateImpl;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.storageengine.api.StorageCommand;

public class ExplicitIndexTransactionStateImplTest {
    private final Map<String, String> config = Collections.singletonMap("provider", "test");
    private final IndexImplementation provider = (IndexImplementation)Mockito.mock(IndexImplementation.class);
    private IndexConfigStore indexConfigStore;

    @Test
    public void tracksNodeCommands() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        state.addNode("index1", 1L, "key1", (Object)"value1");
        state.removeNode("index1", 1L, "key2", (Object)"value2");
        state.addNode("index1", 2L, "key1", (Object)"value3");
        state.addNode("index1", 3L, "key2", (Object)"value4");
        state.removeNode("index2", 4L, "key1", (Object)"value5");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index1");
        indexDefinedCommand.getOrAssignIndexNameId("index2");
        indexDefinedCommand.getOrAssignKeyId("key1");
        indexDefinedCommand.getOrAssignKeyId("key2");
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, ExplicitIndexTransactionStateImplTest.addNode(1, 1L, 1, "value1"), ExplicitIndexTransactionStateImplTest.removeNode(1, 1L, 2, "value2"), ExplicitIndexTransactionStateImplTest.addNode(1, 2L, 1, "value3"), ExplicitIndexTransactionStateImplTest.addNode(1, 3L, 2, "value4"), ExplicitIndexTransactionStateImplTest.removeNode(2, 4L, 1, "value5")));
        Assert.assertEquals(expectedCommands, ExplicitIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void tracksRelationshipCommands() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        state.removeRelationship("index1", 1L, "key1", (Object)"value1");
        state.addRelationship("index1", 1L, "key2", (Object)"value2", 11L, 11L);
        state.removeRelationship("index1", 2L, "key1", (Object)"value3");
        state.addRelationship("index1", 3L, "key2", (Object)"value4", 22L, 22L);
        state.addRelationship("index2", 4L, "key1", (Object)"value5", 33L, 33L);
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index1");
        indexDefinedCommand.getOrAssignIndexNameId("index2");
        indexDefinedCommand.getOrAssignKeyId("key1");
        indexDefinedCommand.getOrAssignKeyId("key2");
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, ExplicitIndexTransactionStateImplTest.removeRelationship(1, 1L, 1, "value1"), ExplicitIndexTransactionStateImplTest.addRelationship(1, 1L, 2, "value2", 11L, 11L), ExplicitIndexTransactionStateImplTest.removeRelationship(1, 2L, 1, "value3"), ExplicitIndexTransactionStateImplTest.addRelationship(1, 3L, 2, "value4", 22L, 22L), ExplicitIndexTransactionStateImplTest.addRelationship(2, 4L, 1, "value5", 33L, 33L)));
        Assert.assertEquals(expectedCommands, ExplicitIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void nodeIndexDeletionRemovesCommands() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        state.addNode("index", 1L, "key", (Object)"value1");
        state.addNode("index", 2L, "key", (Object)"value2");
        state.removeNode("index", 3L, "key", (Object)"value3");
        state.deleteIndex(IndexEntityType.Node, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Node.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete));
        Assert.assertEquals(expectedCommands, ExplicitIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void relationshipIndexDeletionRemovesCommands() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        state.removeRelationship("index", 1L, "key", (Object)"value1");
        state.addRelationship("index", 2L, "key", (Object)"value2", 11L, 11L);
        state.addRelationship("index", 3L, "key", (Object)"value3", 22L, 22L);
        state.deleteIndex(IndexEntityType.Relationship, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Relationship.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete));
        Assert.assertEquals(expectedCommands, ExplicitIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void removalOfNodeIndexDoesNotClearRelationshipCommandsForRelationshipIndexWithSameName() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        state.addNode("index", 1L, "key", (Object)"value");
        state.addRelationship("index", 1L, "key", (Object)"value", 11L, 11L);
        state.deleteIndex(IndexEntityType.Node, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Node.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete, ExplicitIndexTransactionStateImplTest.addRelationship(1, 1L, 1, "value", 11L, 11L)));
        Assert.assertEquals(expectedCommands, ExplicitIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void removalOfRelationshipIndexDoesNotClearNodeCommandsForNodeIndexWithSameName() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        state.addNode("index", 1L, "key", (Object)"value");
        state.addRelationship("index", 1L, "key", (Object)"value", 11L, 11L);
        state.deleteIndex(IndexEntityType.Relationship, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Relationship.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete, ExplicitIndexTransactionStateImplTest.addNode(1, 1L, 1, "value")));
        Assert.assertEquals(expectedCommands, ExplicitIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void shouldReportIndexExists() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        boolean nodeExists = state.checkIndexExistence(IndexEntityType.Node, "name", null);
        boolean relExists = state.checkIndexExistence(IndexEntityType.Relationship, "name", null);
        Assert.assertTrue((boolean)nodeExists);
        Assert.assertTrue((boolean)relExists);
    }

    @Test
    public void shouldReportIndexExistsWithMatchingConfiguration() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        Mockito.when((Object)this.provider.configMatches(ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
        boolean nodeExists = state.checkIndexExistence(IndexEntityType.Node, "name", this.config);
        boolean relExists = state.checkIndexExistence(IndexEntityType.Node, "name", this.config);
        Assert.assertTrue((boolean)nodeExists);
        Assert.assertTrue((boolean)relExists);
    }

    @Test
    public void shouldThrowOnIndexExistsWithMismatchingConfiguration() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        Mockito.when((Object)this.provider.configMatches(ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)false);
        try {
            state.checkIndexExistence(IndexEntityType.Node, "name", this.config);
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            state.checkIndexExistence(IndexEntityType.Node, "name", this.config);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReportIndexDoesNotExist() {
        ExplicitIndexTransactionStateImpl state = this.newExplicitIndexTxState();
        Mockito.when((Object)this.indexConfigStore.get((Class)ArgumentMatchers.any(Class.class), ArgumentMatchers.anyString())).thenReturn(null);
        boolean exists = state.checkIndexExistence(IndexEntityType.Relationship, "name", null);
        Assert.assertFalse((boolean)exists);
    }

    private static Set<StorageCommand> extractCommands(ExplicitIndexTransactionStateImpl state) {
        HashSet<StorageCommand> commands = new HashSet<StorageCommand>();
        state.extractCommands(commands);
        return commands;
    }

    private static Command addNode(int index, long id, int key, Object value) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(index, id, key, value);
        return command;
    }

    private static Command addRelationship(int index, long id, int key, Object value, long startNode, long endNode) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(index, id, key, value, startNode, endNode);
        return command;
    }

    private static Command removeNode(int index, long id, int key, Object value) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(index, IndexEntityType.Node.id(), id, key, value);
        return command;
    }

    private static Command removeRelationship(int index, long id, int key, Object value) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(index, IndexEntityType.Relationship.id(), id, key, value);
        return command;
    }

    private ExplicitIndexTransactionStateImpl newExplicitIndexTxState() {
        this.indexConfigStore = (IndexConfigStore)Mockito.mock(IndexConfigStore.class);
        Mockito.when((Object)this.indexConfigStore.get((Class)ArgumentMatchers.eq(Node.class), ArgumentMatchers.anyString())).thenReturn(this.config);
        Mockito.when((Object)this.indexConfigStore.get((Class)ArgumentMatchers.eq(Relationship.class), ArgumentMatchers.anyString())).thenReturn(this.config);
        ExplicitIndexProvider explicitIndexProvider = (ExplicitIndexProvider)Mockito.mock(ExplicitIndexProvider.class);
        Mockito.when((Object)explicitIndexProvider.getProviderByName(ArgumentMatchers.anyString())).thenReturn((Object)this.provider);
        return new ExplicitIndexTransactionStateImpl(this.indexConfigStore, explicitIndexProvider);
    }
}

