/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.storageengine.api.RelationshipDirection;

public class RelationshipChangesForNodeTest {
    @Test
    public void shouldGetRelationships() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        int TYPE = 2;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        LongIterator rawRelationships = changes.getRelationships();
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawRelationships), this.ids(1L, 2L, 3L, 4L, 5L, 6L));
    }

    @Test
    public void shouldGetRelationshipsByTypeAndDirection() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        int TYPE = 2;
        int DECOY_TYPE = 666;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(10L, 666, RelationshipDirection.INCOMING);
        changes.addRelationship(11L, 666, RelationshipDirection.OUTGOING);
        changes.addRelationship(12L, 666, RelationshipDirection.LOOP);
        LongIterator rawIncoming = changes.getRelationships(RelationshipDirection.INCOMING, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawIncoming), this.ids(1L));
        LongIterator rawOutgoing = changes.getRelationships(RelationshipDirection.OUTGOING, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawOutgoing), this.ids(2L, 3L));
        LongIterator rawLoops = changes.getRelationships(RelationshipDirection.LOOP, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawLoops), this.ids(4L, 5L, 6L));
    }

    private Matcher<long[]> ids(long ... ids) {
        return Matchers.equalTo((Object)ids);
    }
}

