/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.state.GraphStateImpl;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class TxStateTest {
    private static final CachingOffHeapBlockAllocator BLOCK_ALLOCATOR = new CachingOffHeapBlockAllocator();
    public final RandomRule random = new RandomRule();
    private final IndexDescriptor indexOn_1_1 = TestIndexDescriptorFactory.forLabel(1, 1);
    private final IndexDescriptor indexOn_2_1 = TestIndexDescriptorFactory.forLabel(2, 1);
    private final IndexDescriptor indexOnRels = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forRelType((int)3, (int[])new int[]{1}));
    private CollectionsFactory collectionsFactory;
    private TxState state;
    @Parameterized.Parameter
    public CollectionsFactorySupplier collectionsFactorySupplier;

    @Rule
    public final TestRule repeatWithDifferentRandomization() {
        return RuleChain.outerRule((TestRule)new RepeatRule()).around((TestRule)this.random);
    }

    @Parameterized.Parameters(name="{0}")
    public static List<CollectionsFactorySupplier> data() {
        return Arrays.asList(new CollectionsFactorySupplier(){

            public CollectionsFactory create() {
                return CollectionsFactorySupplier.ON_HEAP.create();
            }

            public String toString() {
                return "On heap";
            }
        }, new CollectionsFactorySupplier(){

            public CollectionsFactory create() {
                return new OffHeapCollectionsFactory((OffHeapBlockAllocator)BLOCK_ALLOCATOR);
            }

            public String toString() {
                return "Off heap";
            }
        });
    }

    @AfterClass
    public static void afterAll() {
        BLOCK_ALLOCATOR.release();
    }

    @Before
    public void before() {
        this.collectionsFactory = (CollectionsFactory)Mockito.spy((Object)this.collectionsFactorySupplier.create());
        this.state = new TxState(this.collectionsFactory);
    }

    @After
    public void after() {
        this.collectionsFactory.release();
        Assert.assertEquals((String)"Seems like native memory is leaking", (long)0L, (long)this.collectionsFactory.getMemoryTracker().usedDirectMemory());
    }

    @Test
    public void shouldGetAddedLabels() {
        this.state.nodeDoAddLabel(1L, 0L);
        this.state.nodeDoAddLabel(1L, 1L);
        this.state.nodeDoAddLabel(2L, 1L);
        LongSet addedLabels = this.state.nodeStateLabelDiffSets(1L).getAdded();
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L}), (Object)addedLabels);
    }

    @Test
    public void shouldGetRemovedLabels() {
        this.state.nodeDoRemoveLabel(1L, 0L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        this.state.nodeDoRemoveLabel(2L, 1L);
        LongSet removedLabels = this.state.nodeStateLabelDiffSets(1L).getRemoved();
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L}), (Object)removedLabels);
    }

    @Test
    public void removeAddedLabelShouldRemoveFromAdded() {
        this.state.nodeDoAddLabel(1L, 0L);
        this.state.nodeDoAddLabel(1L, 1L);
        this.state.nodeDoAddLabel(2L, 1L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{2L}), (Object)this.state.nodeStateLabelDiffSets(1L).getAdded());
    }

    @Test
    public void addRemovedLabelShouldRemoveFromRemoved() {
        this.state.nodeDoRemoveLabel(1L, 0L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        this.state.nodeDoRemoveLabel(2L, 1L);
        this.state.nodeDoAddLabel(1L, 1L);
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{2L}), (Object)this.state.nodeStateLabelDiffSets(1L).getRemoved());
    }

    @Test
    public void shouldMapFromRemovedLabelToNodes() {
        this.state.nodeDoRemoveLabel(1L, 0L);
        this.state.nodeDoRemoveLabel(2L, 0L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        this.state.nodeDoRemoveLabel(3L, 1L);
        this.state.nodeDoRemoveLabel(2L, 2L);
        LongSet nodes = this.state.nodesWithLabelChanged(2L).getRemoved();
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{0L, 2L}), (Object)nodes);
    }

    @Test
    public void shouldComputeIndexUpdatesOnUninitializedTxState() {
        UnmodifiableMap diffSets = this.state.getIndexUpdates(this.indexOn_1_1.schema());
        Assert.assertNull((Object)diffSets);
    }

    @Test
    public void shouldComputeSortedIndexUpdatesOnUninitializedTxState() {
        NavigableMap diffSets = this.state.getSortedIndexUpdates(this.indexOn_1_1.schema());
        Assert.assertNull((Object)diffSets);
    }

    @Test
    public void shouldComputeIndexUpdatesOnEmptyTxState() {
        this.addNodesToIndex(this.indexOn_2_1).withDefaultStringProperties(42L);
        UnmodifiableMap diffSets = this.state.getIndexUpdates(this.indexOn_1_1.schema());
        Assert.assertNull((Object)diffSets);
    }

    @Test
    public void shouldComputeSortedIndexUpdatesOnEmptyTxState() {
        this.addNodesToIndex(this.indexOn_2_1).withDefaultStringProperties(42L);
        NavigableMap diffSets = this.state.getSortedIndexUpdates(this.indexOn_1_1.schema());
        Assert.assertNull((Object)diffSets);
    }

    @Test
    public void shouldComputeIndexUpdatesOnTxStateWithAddedNodes() {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(43L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(41L);
        UnmodifiableMap diffSets = this.state.getIndexUpdates(this.indexOn_1_1.schema());
        TxStateTest.assertEqualDiffSets(this.addedNodes(42L), (LongDiffSets)diffSets.get((Object)ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"value42")})));
        TxStateTest.assertEqualDiffSets(this.addedNodes(43L), (LongDiffSets)diffSets.get((Object)ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"value43")})));
        TxStateTest.assertEqualDiffSets(this.addedNodes(41L), (LongDiffSets)diffSets.get((Object)ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"value41")})));
    }

    @Test
    public void shouldComputeSortedIndexUpdatesOnTxStateWithAddedNodes() {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(43L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(41L);
        NavigableMap diffSets = this.state.getSortedIndexUpdates(this.indexOn_1_1.schema());
        TreeMap<ValueTuple, LongDiffSets> expected = this.sortedAddedNodesDiffSets(42L, 41L, 43L);
        Assert.assertEquals(expected.keySet(), diffSets.keySet());
        for (ValueTuple key : expected.keySet()) {
            TxStateTest.assertEqualDiffSets(expected.get(key), (LongDiffSets)diffSets.get(key));
        }
    }

    @Test
    public void shouldAddAndGetByLabel() {
        this.state.indexDoAdd(this.indexOn_1_1);
        this.state.indexDoAdd(this.indexOn_2_1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexDiffSetsByLabel(this.indexOn_1_1.schema().keyId()).getAdded());
    }

    @Test
    public void shouldAddAndGetByRelType() {
        this.state.indexDoAdd(this.indexOnRels);
        this.state.indexDoAdd(this.indexOn_2_1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOnRels}), (Object)this.state.indexDiffSetsByRelationshipType(this.indexOnRels.schema().keyId()).getAdded());
    }

    @Test
    public void shouldAddAndGetByRuleId() {
        this.state.indexDoAdd(this.indexOn_1_1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexChanges().getAdded());
    }

    @Test
    public void shouldListNodeAsDeletedIfItIsDeleted() {
        long nodeId = 1337L;
        this.state.nodeDoDelete(nodeId);
        Assert.assertThat((Object)this.state.addedAndRemovedNodes().getRemoved(), (Matcher)IsEqual.equalTo((Object)LongHashSet.newSetWith((long[])new long[]{nodeId})));
    }

    @Test
    public void shouldAddUniquenessConstraint() {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint, 7L);
        DiffSets diff = this.state.constraintsChangesForLabel(1);
        Assert.assertEquals(Collections.singleton(constraint), (Object)diff.getAdded());
        Assert.assertTrue((boolean)diff.getRemoved().isEmpty());
    }

    @Test
    public void addingUniquenessConstraintShouldBeIdempotent() {
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint1, 7L);
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, 19L);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
    }

    @Test
    public void shouldDifferentiateBetweenUniquenessConstraintsForDifferentLabels() {
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint1, 7L);
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{17});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, 19L);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForLabel(2).getAdded());
    }

    @Test
    public void shouldAddRelationshipPropertyExistenceConstraint() {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint);
        Assert.assertEquals(Collections.singleton(constraint), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    public void addingRelationshipPropertyExistenceConstraintConstraintShouldBeIdempotent() {
        RelExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        RelExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint2);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    public void shouldDropRelationshipPropertyExistenceConstraint() {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint);
        this.state.constraintDoDrop((ConstraintDescriptor)constraint);
        Assert.assertTrue((boolean)this.state.constraintsChangesForRelationshipType(1).isEmpty());
    }

    @Test
    public void shouldDifferentiateRelationshipPropertyExistenceConstraints() {
        RelExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{11});
        RelExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{22});
        RelExistenceConstraintDescriptor constraint3 = ConstraintDescriptorFactory.existsForRelType((int)3, (int[])new int[]{33});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint2);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint3);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2}), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForSchema(constraint1.schema()).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForSchema(constraint2.schema()).getAdded());
        Assert.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForRelationshipType(3).getAdded());
        Assert.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForSchema(constraint3.schema()).getAdded());
    }

    @Test
    public void shouldListRelationshipsAsCreatedIfCreated() {
        long relId = 10L;
        this.state.relationshipDoCreate(relId, 0, 1L, 2L);
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertTrue((boolean)this.state.relationshipIsAddedInThisTx(relId));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedNode() throws Exception {
        this.state.nodeDoCreate(0L);
        this.state.nodeDoDelete(0L);
        this.state.nodeDoCreate(1L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedNode(long id) {
                Assert.assertEquals((String)"Should not create any other node than 1", (long)1L, (long)id);
            }

            public void visitDeletedNode(long id) {
                Assert.fail((String)"Should not delete any node");
            }
        });
    }

    @Test
    public void shouldVisitDeletedNode() throws Exception {
        this.state.nodeDoDelete(42L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedNode(long id) {
                Assert.assertEquals((String)"Wrong deleted node id", (long)42L, (long)id);
            }
        });
    }

    @Test
    public void shouldReportDeletedNodeIfItWasCreatedAndDeletedInSameTx() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        this.state.nodeDoDelete(nodeId);
        Assert.assertTrue((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    public void shouldNotReportDeletedNodeIfItIsNotDeleted() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        Assert.assertFalse((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedRelationship() throws Exception {
        this.state.relationshipDoCreate(0L, 0, 1L, 2L);
        this.state.relationshipDoDelete(0L, 0, 1L, 2L);
        this.state.relationshipDoCreate(1L, 0, 2L, 3L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                Assert.assertEquals((String)"Should not create any other relationship than 1", (long)1L, (long)id);
            }

            public void visitDeletedRelationship(long id) {
                Assert.fail((String)"Should not delete any relationship");
            }
        });
    }

    @Test
    public void doNotVisitNotModifiedPropertiesOnModifiedNodes() throws ConstraintValidationException, CreateConstraintFailureException {
        this.state.nodeDoAddLabel(5L, 1L);
        final MutableBoolean labelsChecked = new MutableBoolean();
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
                labelsChecked.setTrue();
                Assert.assertEquals((long)1L, (long)id);
                Assert.assertEquals((long)1L, (long)added.size());
                Assert.assertTrue((boolean)added.contains(5L));
                Assert.assertTrue((boolean)removed.isEmpty());
            }

            public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
                Assert.fail((String)"Properties were not changed.");
            }
        });
        Assert.assertTrue((boolean)labelsChecked.booleanValue());
    }

    @Test
    public void doNotVisitNotModifiedLabelsOnModifiedNodes() throws ConstraintValidationException, CreateConstraintFailureException {
        this.state.nodeDoAddProperty(1L, 2, (Value)Values.stringValue((String)"propertyValue"));
        final MutableBoolean propertiesChecked = new MutableBoolean();
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
                Assert.fail((String)"Labels were not changed.");
            }

            public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
                propertiesChecked.setTrue();
                Assert.assertEquals((long)1L, (long)id);
                Assert.assertFalse((boolean)changed.hasNext());
                Assert.assertTrue((boolean)removed.isEmpty());
                Assert.assertEquals((long)1L, (long)Iterators.count(added, (Predicate)Predicates.alwaysTrue()));
            }
        });
        Assert.assertTrue((boolean)propertiesChecked.booleanValue());
    }

    @Test
    public void shouldVisitDeletedRelationship() throws Exception {
        this.state.relationshipDoDelete(42L, 2, 3L, 4L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedRelationship(long id) {
                Assert.assertEquals((String)"Wrong deleted relationship id", (long)42L, (long)id);
            }
        });
    }

    @Test
    public void shouldReportDeletedRelationshipIfItWasCreatedAndDeletedInSameTx() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        this.state.relationshipDoDelete(relationshipId, relationshipType, startNodeId, endNodeId);
        Assert.assertTrue((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    public void shouldNotReportDeletedRelationshipIfItIsNotDeleted() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        Assert.assertFalse((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeDeletedNodes() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeCreatedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedRelationshipsBeforeDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoDelete((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitEarly();
            }

            public void visitDeletedRelationship(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitDeletedNodesAfterDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitDeletedRelationship(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    public void getOrCreateNodeState_props_useCollectionsFactory() {
        NodeStateImpl nodeState = this.state.getOrCreateNodeState(1L);
        nodeState.addProperty(2, (Value)Values.stringValue((String)"foo"));
        nodeState.removeProperty(3);
        nodeState.changeProperty(4, (Value)Values.stringValue((String)"bar"));
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newValuesMap();
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)1))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    @Test
    public void getOrCreateGraphState_useCollectionsFactory() {
        GraphStateImpl graphState = this.state.getOrCreateGraphState();
        graphState.addProperty(2, (Value)Values.stringValue((String)"foo"));
        graphState.removeProperty(3);
        graphState.changeProperty(4, (Value)Values.stringValue((String)"bar"));
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newValuesMap();
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)1))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    @Test
    public void getOrCreateLabelStateNodeDiffSets_useCollectionsFactory() {
        MutableLongDiffSets diffSets = this.state.getOrCreateLabelStateNodeDiffSets(1L);
        diffSets.add(1L);
        diffSets.remove(2L);
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    @Test
    public void getOrCreateIndexUpdatesForSeek_useCollectionsFactory() {
        MutableLongDiffSets diffSets = this.state.getOrCreateIndexUpdatesForSeek(new HashMap(), ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"test")}));
        diffSets.add(1L);
        diffSets.remove(2L);
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    private LongDiffSets addedNodes(long ... added) {
        return new MutableLongDiffSetsImpl(LongSets.mutable.of(added), LongSets.mutable.empty(), this.collectionsFactory);
    }

    private TreeMap<ValueTuple, LongDiffSets> sortedAddedNodesDiffSets(long ... added) {
        TreeMap<ValueTuple, LongDiffSets> map = new TreeMap<ValueTuple, LongDiffSets>(ValueTuple.COMPARATOR);
        for (long node : added) {
            map.put(ValueTuple.of((Value[])new Value[]{Values.stringValue((String)("value" + node))}), this.addedNodes(node));
        }
        return map;
    }

    private IndexUpdater addNodesToIndex(final IndexDescriptor descriptor) {
        return new IndexUpdater(){

            @Override
            public void withDefaultStringProperties(long ... nodeIds) {
                ArrayList entries = new ArrayList(nodeIds.length);
                for (long nodeId : nodeIds) {
                    entries.add(Pair.of((Object)nodeId, (Object)("value" + nodeId)));
                }
                this.withProperties(entries);
            }

            private <T> void withProperties(Collection<Pair<Long, T>> nodesWithValues) {
                int labelId = descriptor.schema().keyId();
                int propertyKeyId = descriptor.schema().getPropertyId();
                for (Pair<Long, T> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel((long)labelId, nodeId);
                    Value valueAfter = Values.of((Object)entry.other());
                    TxStateTest.this.state.nodeDoAddProperty(nodeId, propertyKeyId, valueAfter);
                    TxStateTest.this.state.indexDoUpdateEntry(descriptor.schema(), nodeId, null, ValueTuple.of((Value[])new Value[]{valueAfter}));
                }
            }
        };
    }

    private static void assertEqualDiffSets(LongDiffSets expected, LongDiffSets actual) {
        Assert.assertEquals((Object)expected.getRemoved(), (Object)actual.getRemoved());
        Assert.assertEquals((Object)expected.getAdded(), (Object)actual.getAdded());
    }

    private static interface IndexUpdater {
        public void withDefaultStringProperties(long ... var1);
    }

    abstract class VisitationOrder
    extends TxStateVisitor.Adapter {
        private final Set<String> visitMethods = new HashSet<String>();
        private boolean late;

        VisitationOrder(int size) {
            for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                if (!method.getName().startsWith("visit")) continue;
                this.visitMethods.add(method.getName());
            }
            Assert.assertEquals((String)"should implement exactly two visit*(...) methods", (long)2L, (long)this.visitMethods.size());
            do {
                if (TxStateTest.this.random.nextBoolean()) {
                    this.createEarlyState();
                    continue;
                }
                this.createLateState();
            } while (size-- > 0);
        }

        abstract void createEarlyState();

        abstract void createLateState();

        final void visitEarly() {
            if (this.late) {
                String early = "the early visit*-method";
                String late = "the late visit*-method";
                for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
                    if (!this.visitMethods.contains(trace.getMethodName())) continue;
                    early = trace.getMethodName();
                    for (String method : this.visitMethods) {
                        if (method.equals(early)) continue;
                        late = method;
                    }
                    break;
                }
                Assert.fail((String)(early + "(...) should not be invoked after " + late + "(...)"));
            }
        }

        final void visitLate() {
            this.late = true;
        }
    }
}

