/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.core.DelegatingTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenHolder;

public class DelegatingTokenHolderTest {
    private TokenCreator creator;
    private TokenHolder holder;

    @Before
    public void setUp() throws Exception {
        this.creator = (TokenCreator)Mockito.mock(TokenCreator.class);
        this.holder = new DelegatingTokenHolder(this.creator, "Dummy");
    }

    @Test
    public void mustCreateAndCacheNewTokens() throws Exception {
        Mockito.when((Object)this.creator.createToken("token")).thenReturn((Object)42);
        Assert.assertThat((Object)this.holder.getOrCreateId("token"), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)this.holder.getOrCreateId("token"), (Matcher)Matchers.is((Object)42));
        ((TokenCreator)Mockito.verify((Object)this.creator)).createToken("token");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.creator});
    }

    @Test
    public void batchTokenGetMustReturnWhetherThereWereUnresolvedTokens() {
        this.holder.setInitialTokens(Arrays.asList(this.token("a", 1), this.token("b", 2)));
        String[] names = new String[]{"a", "X", "b"};
        int[] ids = new int[]{-1, -1, -1};
        Assert.assertTrue((boolean)this.holder.getIdsByNames(names, ids));
        Assert.assertThat((Object)ids[0], (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)ids[1], (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)ids[2], (Matcher)Matchers.is((Object)2));
        names = new String[]{"a", "b"};
        ids = new int[]{-1, -1};
        Assert.assertFalse((boolean)this.holder.getIdsByNames(names, ids));
        Assert.assertThat((Object)ids[0], (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)ids[1], (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void batchTokenCreateMustIgnoreExistingTokens() throws Exception {
        this.initialTokensABC();
        AtomicInteger nextId = new AtomicInteger(42);
        this.mockAssignNewTokenIdsInBatch(nextId);
        String[] names = new String[]{"b", "X", "a", "Y", "c"};
        int[] ids = new int[names.length];
        this.holder.getOrCreateIds(names, ids);
        Assert.assertThat((Object)ids.length, (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)ids[0], (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)ids[1], (Matcher)Matchers.isOneOf((Object[])new Integer[]{42, 43}));
        Assert.assertThat((Object)ids[2], (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)ids[3], (Matcher)Matchers.isOneOf((Object[])new Integer[]{42, 43}));
        Assert.assertThat((Object)ids[4], (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)nextId.get(), (Matcher)Matchers.is((Object)44));
        this.holder.getTokenById(42);
        this.holder.getTokenById(43);
    }

    private void mockAssignNewTokenIdsInBatch(AtomicInteger nextId) throws KernelException {
        ((TokenCreator)Mockito.doAnswer(inv -> {
            int[] ids = (int[])inv.getArgument(1);
            IntPredicate filter = (IntPredicate)inv.getArgument(2);
            for (int i = 0; i < ids.length; ++i) {
                if (!filter.test(i)) continue;
                ids[i] = nextId.getAndIncrement();
            }
            return null;
        }).when((Object)this.creator)).createTokens((String[])ArgumentMatchers.any(String[].class), (int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class));
    }

    private void initialTokensABC() throws KernelException {
        this.holder.setInitialTokens(Arrays.asList(this.token("a", 1), this.token("b", 2)));
        Mockito.when((Object)this.creator.createToken("c")).thenReturn((Object)3);
        Assert.assertThat((Object)this.holder.getOrCreateId("c"), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void batchTokenCreateMustDeduplicateTokenCreates() throws Exception {
        this.initialTokensABC();
        AtomicInteger nextId = new AtomicInteger(42);
        this.mockAssignNewTokenIdsInBatch(nextId);
        String[] names = new String[]{"b", "b", "X", "a", "X", "c"};
        int[] ids = new int[names.length];
        this.holder.getOrCreateIds(names, ids);
        Assert.assertThat((Object)ids.length, (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)ids[0], (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)ids[1], (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)ids[2], (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)ids[3], (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)ids[4], (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)ids[5], (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)nextId.get(), (Matcher)Matchers.is((Object)43));
        this.holder.getTokenById(42);
    }

    @Test(expected=IllegalArgumentException.class)
    public void batchTokenCreateMustThrowOnArraysOfDifferentLengths() {
        this.holder.getOrCreateIds(new String[3], new int[2]);
    }

    @Test
    public void shouldClearTokensAsPartOfInitialTokenLoading() {
        this.holder.setInitialTokens(Arrays.asList(this.token("one", 1), this.token("two", 2)));
        this.assertTokens(this.holder.getAllTokens(), this.token("one", 1), this.token("two", 2));
        this.holder.setInitialTokens(Arrays.asList(this.token("two", 2), this.token("three", 3), this.token("four", 4)));
        this.assertTokens(this.holder.getAllTokens(), this.token("two", 2), this.token("three", 3), this.token("four", 4));
    }

    private void assertTokens(Iterable<NamedToken> allTokens, NamedToken ... expectedTokens) {
        HashMap<String, NamedToken> existing = new HashMap<String, NamedToken>();
        for (NamedToken token : allTokens) {
            existing.put(token.name(), token);
        }
        HashMap<String, NamedToken> expected = new HashMap<String, NamedToken>();
        for (NamedToken token : expectedTokens) {
            expected.put(token.name(), token);
        }
        Assert.assertEquals(expected, existing);
    }

    private NamedToken token(String name, int id) {
        return new NamedToken(name, id);
    }
}

