/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.TokenRegistry;

public class TokenRegistryTest {
    private static final String INBOUND2_TYPE = "inbound2";
    private static final String INBOUND1_TYPE = "inbound1";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void addTokenWithDuplicatedNotAllowed() {
        TokenRegistry tokenCache = this.createTokenCache();
        tokenCache.put(new NamedToken(INBOUND1_TYPE, 1));
        tokenCache.put(new NamedToken(INBOUND2_TYPE, 2));
        this.expectedException.expect(NonUniqueTokenException.class);
        this.expectedException.expectMessage("The testType \"inbound1\" is not unique");
        tokenCache.put(new NamedToken(INBOUND1_TYPE, 3));
    }

    @Test
    public void keepOriginalTokenWhenAddDuplicate() {
        TokenRegistry tokenCache = this.createTokenCache();
        tokenCache.put(new NamedToken(INBOUND1_TYPE, 1));
        tokenCache.put(new NamedToken(INBOUND2_TYPE, 2));
        this.tryToAddDuplicate(tokenCache);
        Assert.assertEquals((long)1L, (long)tokenCache.getId(INBOUND1_TYPE).intValue());
        Assert.assertEquals((long)2L, (long)tokenCache.getId(INBOUND2_TYPE).intValue());
        Assert.assertNull((Object)tokenCache.getToken(3));
    }

    private TokenRegistry createTokenCache() {
        return new TokenRegistry("testType");
    }

    private void tryToAddDuplicate(TokenRegistry tokenCache) {
        try {
            tokenCache.put(new NamedToken(INBOUND1_TYPE, 3));
        }
        catch (NonUniqueTokenException nonUniqueTokenException) {
            // empty catch block
        }
    }
}

