/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.HashSet;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cursor.RawCursor;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIterator;

public class LabelScanValueIteratorTest {
    @Test
    public void shouldCloseExhaustedCursors() throws Exception {
        RawCursor cursor = (RawCursor)Mockito.mock(RawCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)false);
        HashSet toRemoveFrom = new HashSet();
        LabelScanValueIterator iterator = new LabelScanValueIterator(cursor, toRemoveFrom, -1L);
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.never())).close();
        this.exhaust((LongIterator)iterator);
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).close();
        iterator.hasNext();
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)toRemoveFrom.isEmpty());
    }

    private void exhaust(LongIterator iterator) {
        while (iterator.hasNext()) {
            iterator.next();
        }
    }
}

