/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Random;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanLayout;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class NativeLabelScanStoreIT {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystem = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final LifeRule life = new LifeRule(true);
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fileSystem).around((TestRule)this.directory).around((TestRule)this.pageCacheRule).around((TestRule)this.life).around((TestRule)this.random);
    private NativeLabelScanStore store;
    private static final int NODE_COUNT = 10000;
    private static final int LABEL_COUNT = 12;
    private PageCache pageCache;
    private File storeFile;
    private int pageSize;

    @Before
    public void before() throws IOException {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystem);
        this.storeFile = NativeLabelScanStore.getLabelScanStoreFile((DatabaseLayout)this.directory.databaseLayout());
        this.pageSize = Math.min(this.pageCache.pageSize(), 256 << this.random.nextInt(5));
        this.newLabelScanStore();
    }

    @Test
    public void shouldRandomlyTestIt() throws Exception {
        long[] expected = new long[10000];
        this.randomModifications(expected, 10000);
        for (int i = 0; i < 100; ++i) {
            this.verifyReads(expected);
            this.randomModifications(expected, 1000);
        }
    }

    @Test
    public void shouldRemoveEmptyBitMaps() throws IOException {
        Throwable throwable;
        RawCursor seek2;
        int nodeId = 1;
        long nodeIdRange = NativeLabelScanWriter.rangeOf((long)nodeId);
        int labelId = 1;
        long[] noLabels = new long[]{};
        long[] singleLabel = new long[]{labelId};
        LabelScanKey key = new LabelScanLayout().newKey();
        key.set(labelId, nodeIdRange);
        try (LabelScanWriter writer = this.store.newWriter();){
            writer.write(NodeLabelUpdate.labelChanges((long)nodeId, (long[])noLabels, (long[])singleLabel));
        }
        this.store.force(IOLimiter.UNLIMITED);
        this.store.shutdown();
        var9_8 = null;
        try (GBPTree<LabelScanKey, LabelScanValue> tree = this.openTree();){
            seek2 = tree.seek((Object)key, (Object)key);
            throwable = null;
            try {
                Assert.assertTrue((String)"Expected to find the newly inserted entry", (boolean)seek2.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (seek2 != null) {
                    if (throwable != null) {
                        try {
                            seek2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        seek2.close();
                    }
                }
            }
        }
        catch (Throwable seek2) {
            var9_8 = seek2;
            throw seek2;
        }
        this.newLabelScanStore();
        writer = this.store.newWriter();
        var9_8 = null;
        try {
            writer.write(NodeLabelUpdate.labelChanges((long)nodeId, (long[])singleLabel, (long[])noLabels));
        }
        catch (Throwable seek2) {
            var9_8 = seek2;
            throw seek2;
        }
        finally {
            if (writer != null) {
                if (var9_8 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable seek2) {
                        var9_8.addSuppressed(seek2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        this.store.force(IOLimiter.UNLIMITED);
        this.store.shutdown();
        tree = this.openTree();
        var9_8 = null;
        try {
            seek2 = tree.seek((Object)key, (Object)key);
            throwable = null;
            try {
                Assert.assertFalse((String)"Expected tree to be empty after removing the last label", (boolean)seek2.next());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (seek2 != null) {
                    if (throwable != null) {
                        try {
                            seek2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        seek2.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var9_8 = throwable6;
            throw throwable6;
        }
        finally {
            if (tree != null) {
                if (var9_8 != null) {
                    try {
                        tree.close();
                    }
                    catch (Throwable throwable7) {
                        var9_8.addSuppressed(throwable7);
                    }
                } else {
                    tree.close();
                }
            }
        }
    }

    private GBPTree<LabelScanKey, LabelScanValue> openTree() {
        return new GBPTree(this.pageCache, this.storeFile, (Layout)new LabelScanLayout(), this.pageSize, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.ignore(), true);
    }

    private void newLabelScanStore() throws IOException {
        if (this.store != null) {
            this.store.shutdown();
        }
        this.store = (NativeLabelScanStore)this.life.add((Lifecycle)new NativeLabelScanStore(this.pageCache, this.directory.databaseLayout(), (FileSystemAbstraction)this.fileSystem, FullStoreChangeStream.EMPTY, false, new Monitors(), RecoveryCleanupWorkCollector.immediate(), this.pageSize));
    }

    private void verifyReads(long[] expected) {
        try (LabelScanReader reader = this.store.newReader();){
            for (int i = 0; i < 12; ++i) {
                long[] actualNodes = PrimitiveLongCollections.asArray((LongIterator)reader.nodesWithLabel(i));
                long[] expectedNodes = NativeLabelScanStoreIT.nodesWithLabel(expected, i);
                Assert.assertArrayEquals((long[])expectedNodes, (long[])actualNodes);
            }
        }
    }

    public static long[] nodesWithLabel(long[] expected, int labelId) {
        int mask = 1 << labelId;
        int count = 0;
        for (long labels : expected) {
            if ((labels & (long)mask) == 0L) continue;
            ++count;
        }
        long[] result = new long[count];
        int cursor = 0;
        for (int nodeId = 0; nodeId < expected.length; ++nodeId) {
            long labels;
            labels = expected[nodeId];
            if ((labels & (long)mask) == 0L) continue;
            result[cursor++] = nodeId;
        }
        return result;
    }

    private void randomModifications(long[] expected, int count) throws IOException {
        BitSet editedNodes = new BitSet();
        try (LabelScanWriter writer = this.store.newWriter();){
            for (int i = 0; i < count; ++i) {
                int nodeId = this.random.nextInt(10000);
                if (editedNodes.get(nodeId)) {
                    --i;
                    continue;
                }
                int changeSize = this.random.nextInt(3) + 1;
                long labels = expected[nodeId];
                long[] labelsBefore = NativeLabelScanStoreIT.getLabels(labels);
                for (int j = 0; j < changeSize; ++j) {
                    labels = NativeLabelScanStoreIT.flipRandom(labels, 12, this.random.random());
                }
                long[] labelsAfter = NativeLabelScanStoreIT.getLabels(labels);
                editedNodes.set(nodeId);
                NodeLabelUpdate labelChanges = NodeLabelUpdate.labelChanges((long)nodeId, (long[])labelsBefore, (long[])labelsAfter);
                writer.write(labelChanges);
                expected[nodeId] = labels;
            }
        }
    }

    public static long flipRandom(long existingLabels, int highLabelId, Random random) {
        return existingLabels ^ (long)(1 << random.nextInt(highLabelId));
    }

    public static long[] getLabels(long bits) {
        long[] result = new long[Long.bitCount(bits)];
        int c = 0;
        for (int labelId = 0; labelId < 12; ++labelId) {
            int mask = 1 << labelId;
            if ((bits & (long)mask) == 0L) continue;
            result[c++] = labelId;
        }
        return result;
    }
}

