/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.test.Race;

class ByteBufferFactoryTest {
    ByteBufferFactoryTest() {
    }

    @Test
    void shouldCloseGlobalAllocationsOnClose() {
        ByteBufferFactory.Allocator allocator = (ByteBufferFactory.Allocator)Mockito.mock(ByteBufferFactory.Allocator.class);
        Mockito.when((Object)allocator.allocate(ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> ByteBuffer.allocate((Integer)invocationOnMock.getArgument(0)));
        ByteBufferFactory factory = new ByteBufferFactory(() -> allocator, 100);
        factory.acquireThreadLocalBuffer();
        factory.releaseThreadLocalBuffer();
        factory.acquireThreadLocalBuffer();
        factory.releaseThreadLocalBuffer();
        factory.globalAllocator().allocate(123);
        factory.globalAllocator().allocate(456);
        factory.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{allocator});
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).allocate(100);
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).allocate(123);
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).allocate(456);
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).close();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldCreateNewInstancesOfLocalAllocators() {
        Supplier allocator = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(allocator.get()).thenAnswer(invocationOnMock -> (ByteBufferFactory.Allocator)Mockito.mock(ByteBufferFactory.Allocator.class));
        ByteBufferFactory factory = new ByteBufferFactory(allocator, 100);
        ByteBufferFactory.Allocator localAllocator1 = factory.newLocalAllocator();
        ByteBufferFactory.Allocator localAllocator2 = factory.newLocalAllocator();
        localAllocator2.close();
        ByteBufferFactory.Allocator localAllocator3 = factory.newLocalAllocator();
        Assertions.assertNotSame((Object)localAllocator1, (Object)localAllocator2);
        Assertions.assertNotSame((Object)localAllocator2, (Object)localAllocator3);
        Assertions.assertNotSame((Object)localAllocator1, (Object)localAllocator3);
    }

    @Test
    void shouldFailAcquireThreadLocalBufferIfAlreadyAcquired() {
        ByteBufferFactory factory = new ByteBufferFactory(() -> ByteBufferFactory.HEAP_ALLOCATOR, 1024);
        factory.acquireThreadLocalBuffer();
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferFactory)factory).acquireThreadLocalBuffer());
        factory.close();
    }

    @Test
    void shouldFailReleaseThreadLocalBufferIfNotAcquired() {
        ByteBufferFactory factory = new ByteBufferFactory(() -> ByteBufferFactory.HEAP_ALLOCATOR, 1024);
        factory.acquireThreadLocalBuffer();
        factory.releaseThreadLocalBuffer();
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferFactory)factory).releaseThreadLocalBuffer());
        factory.close();
    }

    @Test
    void shouldShareThreadLocalBuffersStressfully() throws Throwable {
        int i;
        ByteBufferFactory factory = new ByteBufferFactory(() -> ByteBufferFactory.HEAP_ALLOCATOR, 1024);
        Race race = new Race();
        int threads = 10;
        ArrayList seenBuffers = new ArrayList();
        for (i = 0; i < threads; ++i) {
            HashSet seen = new HashSet();
            seenBuffers.add(seen);
            race.addContestant(() -> {
                for (int j = 0; j < 1000; ++j) {
                    ByteBuffer buffer = factory.acquireThreadLocalBuffer();
                    Assertions.assertNotNull((Object)buffer);
                    seen.add(buffer);
                    factory.releaseThreadLocalBuffer();
                }
            }, 1);
        }
        race.go();
        for (i = 0; i < threads; ++i) {
            Assertions.assertEquals((int)1, (int)((Set)seenBuffers.get(i)).size());
        }
        factory.close();
    }
}

