/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class CompositeGenericKeyTest {
    @Inject
    RandomRule random;

    CompositeGenericKeyTest() {
    }

    @Test
    void testDocumentedStringArrayKeySizeFormulaIsCorrect() {
        CompositeGenericKey key = new CompositeGenericKey(1, (IndexSpecificSpaceFillingCurveSettingsCache)Mockito.mock(IndexSpecificSpaceFillingCurveSettingsCache.class));
        int maxArrayLength = this.random.nextInt(500);
        int maxStringLength = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            String[] strings = this.random.randomValues().nextStringArrayRaw(0, maxArrayLength, 0, maxStringLength);
            key.initialize((long)i);
            key.writeValue(0, Values.of((Object)strings), NativeIndexKey.Inclusion.NEUTRAL);
            Assert.assertThat((Object)this.includingEntityId(this.calculateKeySize(strings)), (Matcher)CoreMatchers.equalTo((Object)key.size()));
        }
    }

    private int includingEntityId(int keySize) {
        return 8 + keySize;
    }

    private int calculateKeySize(String[] strings) {
        int arrayLength = strings.length;
        int totalStringLength = 0;
        for (String string : strings) {
            totalStringLength += string.getBytes(StandardCharsets.UTF_8).length;
        }
        return 3 + 2 * arrayLength + totalStringLength;
    }
}

