/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class FailingGenericNativeIndexProviderFactory
extends KernelExtensionFactory<GenericNativeIndexProviderFactory.Dependencies> {
    public static final String INITIAL_STATE_FAILURE_MESSAGE = "Override initial state as failed";
    public static final String POPULATION_FAILURE_MESSAGE = "Fail on update during population";
    private final GenericNativeIndexProviderFactory actual;
    private final EnumSet<FailureType> failureTypes;

    public FailingGenericNativeIndexProviderFactory(FailureType ... failureTypes) {
        this(new GenericNativeIndexProviderFactory(), 10000, failureTypes);
    }

    private FailingGenericNativeIndexProviderFactory(GenericNativeIndexProviderFactory actual, int priority, FailureType ... failureTypes) {
        super(ExtensionType.DATABASE, (String)actual.getKeys().iterator().next());
        if (failureTypes.length == 0) {
            throw new IllegalArgumentException("At least one failure type, otherwise there's no point in this provider");
        }
        this.actual = actual;
        this.failureTypes = EnumSet.of(failureTypes[0], (Enum[])Arrays.copyOfRange(failureTypes, 1, failureTypes.length));
    }

    public Lifecycle newInstance(KernelContext context, GenericNativeIndexProviderFactory.Dependencies dependencies) {
        final IndexProvider actualProvider = this.actual.newInstance(context, (AbstractIndexProviderFactory.Dependencies)dependencies);
        return new IndexProvider(actualProvider.getProviderDescriptor(), IndexDirectoryStructure.given((IndexDirectoryStructure)actualProvider.directoryStructure())){

            public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, TokenNameLookup tokenNameLookup) {
                final IndexPopulator actualPopulator = actualProvider.getPopulator(descriptor, samplingConfig, bufferFactory, tokenNameLookup);
                if (FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.POPULATION)) {
                    return new IndexPopulator(){

                        public void create() {
                            actualPopulator.create();
                        }

                        public void drop() {
                            actualPopulator.drop();
                        }

                        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
                            throw new RuntimeException(FailingGenericNativeIndexProviderFactory.POPULATION_FAILURE_MESSAGE);
                        }

                        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
                            actualPopulator.verifyDeferredConstraints(nodePropertyAccessor);
                        }

                        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
                            return actualPopulator.newPopulatingUpdater(accessor);
                        }

                        public void close(boolean populationCompletedSuccessfully) {
                            actualPopulator.close(populationCompletedSuccessfully);
                        }

                        public void markAsFailed(String failure) {
                            actualPopulator.markAsFailed(failure);
                        }

                        public void includeSample(IndexEntryUpdate<?> update) {
                            actualPopulator.includeSample(update);
                        }

                        public IndexSample sampleResult() {
                            return actualPopulator.sampleResult();
                        }
                    };
                }
                return actualPopulator;
            }

            public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
                return actualProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);
            }

            public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
                return FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? FailingGenericNativeIndexProviderFactory.INITIAL_STATE_FAILURE_MESSAGE : actualProvider.getPopulationFailure(descriptor);
            }

            public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
                return FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? InternalIndexState.FAILED : actualProvider.getInitialState(descriptor);
            }

            public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
                return actualProvider.getCapability(descriptor);
            }

            public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
                return actualProvider.storeMigrationParticipant(fs, pageCache);
            }
        };
    }

    public static enum FailureType {
        POPULATION,
        INITIAL_STATE;

    }
}

