/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.FileSystemIndexDropAction;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class GenericBlockBasedIndexPopulatorTest {
    private static final StoreIndexDescriptor INDEX_DESCRIPTOR = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1})).withId(1L);
    private static final StoreIndexDescriptor UNIQUE_INDEX_DESCRIPTOR = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1})).withId(1L);
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.simpleNameLookup;
    private IndexDirectoryStructure directoryStructure;
    private File indexFile;
    private FileSystemAbstraction fs;
    private IndexDropAction dropAction;
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();

    @Before
    public void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        this.directoryStructure = IndexDirectoryStructure.directoriesByProvider((File)this.storage.directory().databaseDir()).forProvider(providerDescriptor);
        File indexDir = this.directoryStructure.directoryForIndex(INDEX_DESCRIPTOR.getId());
        this.indexFile = new File(indexDir, "index");
        this.fs = this.storage.fileSystem();
        this.dropAction = new FileSystemIndexDropAction(this.fs, this.directoryStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeExternalUpdateBothBeforeAndAfterScanCompleted() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            TextValue hakuna = Values.stringValue((String)"hakuna");
            TextValue matata = Values.stringValue((String)"matata");
            int hakunaId = 1;
            int matataId = 2;
            this.externalUpdate((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, hakuna, hakunaId);
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.externalUpdate((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, matata, matataId);
            this.assertMatch((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, (Value)hakuna, hakunaId);
            this.assertMatch((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, (Value)matata, matataId);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowOnDuplicatedValuesFromScan() {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            IndexEntryUpdate firstScanUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate secondScanUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            try {
                populator.add(Collections.singleton(firstScanUpdate));
                populator.add(Collections.singleton(secondScanUpdate));
                populator.scanCompleted(PhaseTracker.nullInstance);
                Assert.fail((String)"Expected to throw");
            }
            catch (IndexEntryConflictException indexEntryConflictException) {
                // empty catch block
            }
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowOnDuplicatedValuesFromExternalUpdates() {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            IndexEntryUpdate firstExternalUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate secondExternalUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            try {
                try (IndexUpdater updater = populator.newPopulatingUpdater();){
                    updater.process(firstExternalUpdate);
                    updater.process(secondExternalUpdate);
                }
                populator.scanCompleted(PhaseTracker.nullInstance);
                Assert.fail((String)"Expected to throw");
            }
            catch (IndexEntryConflictException indexEntryConflictException) {
                // empty catch block
            }
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates() {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            IndexEntryUpdate externalUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate scanUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            try {
                try (IndexUpdater updater = populator.newPopulatingUpdater();){
                    updater.process(externalUpdate);
                }
                populator.add(Collections.singleton(scanUpdate));
                populator.scanCompleted(PhaseTracker.nullInstance);
                Assert.fail((String)"Expected to throw");
            }
            catch (IndexEntryConflictException indexEntryConflictException) {
                // empty catch block
            }
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotThrowOnDuplicationsLaterFixedByExternalUpdates() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            Value unique = Values.of((Object)"unique");
            IndexEntryUpdate firstScanUpdate = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate secondScanUpdate = IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            IndexEntryUpdate externalUpdate = IndexEntryUpdate.change((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value)duplicate, (Value)unique);
            populator.add(Collections.singleton(firstScanUpdate));
            try (IndexUpdater updater = populator.newPopulatingUpdater();){
                updater.process(externalUpdate);
            }
            populator.add(Collections.singleton(secondScanUpdate));
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, unique, 1);
            this.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, duplicate, 2);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHandleEntriesOfMaxSize() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            IndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{LayoutTestUtil.generateStringValueResultingInSize(populator.layout, maxKeyValueSize)});
            Set<IndexEntryUpdate> updates = Collections.singleton(update);
            populator.add(updates);
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, update.values()[0], 1);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowForEntriesLargerThanMaxSize() throws IndexEntryConflictException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            IndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{LayoutTestUtil.generateStringValueResultingInSize(populator.layout, maxKeyValueSize + 1)});
            try {
                Set<IndexEntryUpdate> updates = Collections.singleton(update);
                populator.add(updates);
                populator.scanCompleted(PhaseTracker.nullInstance);
                Assert.fail((String)"Expected to throw for value larger than max size.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Failed while trying to write to index, targetIndex=Index( GENERAL, :Label1(property1) ), nodeId=1"));
            }
        }
        finally {
            populator.close(true);
        }
    }

    private void assertHasEntry(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, Value duplicate, int expectedId) {
        try (NativeIndexReader reader = populator.newReader();){
            PrimitiveLongResourceIterator query = reader.query(new IndexQuery[]{IndexQuery.exact((int)INDEX_DESCRIPTOR.properties()[0], (Object)duplicate)});
            Assert.assertTrue((boolean)query.hasNext());
            long id = query.next();
            Assert.assertEquals((long)expectedId, (long)id);
        }
    }

    private void externalUpdate(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, TextValue matata, int matataId) throws IndexEntryConflictException {
        try (IndexUpdater indexUpdater = populator.newPopulatingUpdater();){
            indexUpdater.process(IndexEntryUpdate.add((long)matataId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{matata}));
        }
    }

    private void assertMatch(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, Value value, long id) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleNodeValueClient cursor = new SimpleNodeValueClient();
            reader.query((IndexProgressor.NodeValueClient)cursor, IndexOrder.NONE, true, new IndexQuery[]{IndexQuery.exact((int)INDEX_DESCRIPTOR.properties()[0], (Object)value)});
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)id, (long)cursor.reference);
            Assert.assertEquals((Object)value, (Object)cursor.values[0]);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    private GenericBlockBasedIndexPopulator instantiatePopulator(StoreIndexDescriptor indexDescriptor) {
        Config config = Config.defaults();
        ConfiguredSpaceFillingCurveSettingsCache settingsCache = new ConfiguredSpaceFillingCurveSettingsCache(config);
        IndexSpecificSpaceFillingCurveSettingsCache spatialSettings = new IndexSpecificSpaceFillingCurveSettingsCache(settingsCache, new HashMap());
        GenericLayout layout = new GenericLayout(1, spatialSettings);
        SpaceFillingCurveConfiguration configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration((Config)config);
        GenericBlockBasedIndexPopulator populator = new GenericBlockBasedIndexPopulator(this.storage.pageCache(), this.fs, this.indexFile, (IndexLayout)layout, IndexProvider.Monitor.EMPTY, indexDescriptor, spatialSettings, this.directoryStructure, configuration, this.dropAction, false, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), this.tokenNameLookup);
        populator.create();
        return populator;
    }
}

