/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SimpleHit;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class ResultCursor
implements RawCursor<Hit<StringIndexKey, NativeIndexValue>, IOException> {
    private final Iterator<String> iterator;
    private String current;
    private int pos = -1;

    ResultCursor(Iterator<String> keys) {
        this.iterator = keys;
    }

    public boolean next() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            ++this.pos;
            return true;
        }
        return false;
    }

    public void close() {
    }

    public Hit<StringIndexKey, NativeIndexValue> get() {
        StringIndexKey key = new StringIndexKey();
        key.initialize((long)this.pos);
        key.from((Value)Values.stringValue((String)this.current));
        return new SimpleHit<StringIndexKey, NativeIndexValue>(key, NativeIndexValue.INSTANCE);
    }
}

