/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.junit.Test;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SpatialIndexAccessorTest
extends NativeIndexAccessorTests<SpatialIndexKey, NativeIndexValue> {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());
    private SpatialIndexFiles.SpatialFile spatialFile;

    @Override
    NativeIndexAccessor<SpatialIndexKey, NativeIndexValue> makeAccessor() {
        this.spatialFile = new SpatialIndexFiles.SpatialFile(CoordinateReferenceSystem.WGS84, configuredSettings, super.getIndexFile());
        return new SpatialIndexAccessor.PartAccessor(this.pageCache, (FileSystemAbstraction)this.fs, this.spatialFile.getLayoutForNewIndex(), RecoveryCleanupWorkCollector.immediate(), this.monitor, this.indexDescriptor, (SpaceFillingCurveConfiguration)new StandardConfiguration(), false, SchemaTestUtil.simpleNameLookup);
    }

    @Override
    IndexCapability indexCapability() {
        return SpatialIndexProvider.CAPABILITY;
    }

    @Override
    protected ValueCreatorUtil<SpatialIndexKey, NativeIndexValue> createValueCreatorUtil() {
        return new SpatialValueCreatorUtil(TestIndexDescriptorFactory.forLabel(42, 666).withId(0L), 0.1);
    }

    @Override
    IndexLayout<SpatialIndexKey, NativeIndexValue> createLayout() {
        return new SpatialLayout(crs, configuredSettings.forCRS(crs).curve());
    }

    @Override
    public File getIndexFile() {
        return this.spatialFile.indexFile;
    }

    @Override
    public void shouldNotSeeFilteredEntries() {
    }

    @Override
    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.generateAddUpdatesFor(new Value[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-90.0, -90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-70.0, -70.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-50.0, -50.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{50.0, 50.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{70.0, 70.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{90.0, 90.0})});
        this.shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd(updates);
    }

    @Override
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() {
    }

    @Override
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() {
    }

    @Override
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() {
    }

    @Override
    public void mustHandleNestedQueries() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.generateAddUpdatesFor(new Value[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-90.0, -90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-70.0, -70.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-50.0, -50.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{50.0, 50.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{70.0, 70.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{90.0, 90.0})});
        this.mustHandleNestedQueries(updates);
    }

    @Override
    public void mustHandleMultipleNestedQueries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.generateAddUpdatesFor(new Value[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-90.0, -90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-70.0, -70.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-50.0, -50.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{50.0, 50.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{70.0, 70.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{90.0, 90.0})});
        this.mustHandleMultipleNestedQueries(updates);
    }

    @Override
    public void shouldReturnNoEntriesForRangePredicateOutsideAnyMatch() {
    }

    @Override
    public void respectIndexOrder() {
    }
}

