/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.test.Race;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialIndexCacheTest {
    private static final CoordinateReferenceSystem[] coordinateReferenceSystems = (CoordinateReferenceSystem[])Iterators.stream(CoordinateReferenceSystem.all().iterator()).toArray(CoordinateReferenceSystem[]::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stressCache() throws Exception {
        StringFactory factory = new StringFactory();
        SpatialIndexCache cache = new SpatialIndexCache((SpatialIndexCache.Factory)factory);
        ExecutorService pool = Executors.newFixedThreadPool(20);
        Future[] futures = new Future[100];
        AtomicBoolean shouldContinue = new AtomicBoolean(true);
        try {
            for (int i = 0; i < futures.length; ++i) {
                futures[i] = pool.submit(new CacheStresser((SpatialIndexCache<String>)cache, shouldContinue));
            }
            Thread.sleep(5000L);
            shouldContinue.set(false);
            for (Future future : futures) {
                future.get(10L, TimeUnit.SECONDS);
            }
        }
        finally {
            pool.shutdown();
        }
    }

    @Test
    public void stressInstantiationWithClose() throws Throwable {
        StringFactory factory = new StringFactory();
        SpatialIndexCache cache = new SpatialIndexCache((SpatialIndexCache.Factory)factory);
        Race race = new Race().withRandomStartDelays();
        MutableInt instantiatedAtClose = new MutableInt();
        race.addContestant(() -> {
            try {
                cache.uncheckedSelect(CoordinateReferenceSystem.WGS84);
                cache.uncheckedSelect(CoordinateReferenceSystem.Cartesian_3D);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }, 1);
        race.addContestant(() -> {
            cache.closeInstantiateCloseLock();
            instantiatedAtClose.setValue((Number)Iterables.count((Iterable)cache));
        }, 1);
        race.go();
        try {
            cache.uncheckedSelect(CoordinateReferenceSystem.Cartesian);
            Assert.fail((String)"No instantiation after closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)instantiatedAtClose.intValue(), (long)Iterables.count((Iterable)cache));
    }

    private static class StringFactory
    implements SpatialIndexCache.Factory<String> {
        AtomicInteger[] counters = new AtomicInteger[SpatialIndexCacheTest.access$000().length];

        StringFactory() {
            for (int i = 0; i < this.counters.length; ++i) {
                this.counters[i] = new AtomicInteger(0);
            }
        }

        public String newSpatial(CoordinateReferenceSystem crs) {
            for (int i = 0; i < coordinateReferenceSystems.length; ++i) {
                if (!coordinateReferenceSystems[i].equals((Object)crs)) continue;
                int count = this.counters[i].incrementAndGet();
                if (count <= 1) break;
                throw new IllegalStateException("called new on same crs multiple times");
            }
            return crs.toString();
        }
    }

    static class CacheStresser
    implements Runnable {
        private final SpatialIndexCache<String> cache;
        private final AtomicBoolean shouldContinue;
        private final Random random = new Random();

        CacheStresser(SpatialIndexCache<String> cache, AtomicBoolean shouldContinue) {
            this.cache = cache;
            this.shouldContinue = shouldContinue;
        }

        @Override
        public void run() {
            while (this.shouldContinue.get()) {
                this.stress();
            }
        }

        private void stress() {
            this.cache.select(coordinateReferenceSystems[this.random.nextInt(coordinateReferenceSystems.length)]);
            for (String s : this.cache) {
                if (s != null) continue;
                throw new IllegalStateException("iterated over null");
            }
        }
    }
}

