/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ThrowingConflictDetectorTest {
    private final ThrowingConflictDetector<NumberIndexKey, NativeIndexValue> detector = new ThrowingConflictDetector(true);

    @Test
    public void shouldReportConflictOnSameValueAndDifferentEntityIds() {
        Value value = Values.of((Object)123);
        long entityId1 = 10L;
        long entityId2 = 20L;
        ValueMerger.MergeResult mergeResult = this.detector.merge((NativeIndexKey)ThrowingConflictDetectorTest.key(entityId1, value), (NativeIndexKey)ThrowingConflictDetectorTest.key(entityId2, value), NativeIndexValue.INSTANCE, NativeIndexValue.INSTANCE);
        Assertions.assertSame((Object)ValueMerger.MergeResult.UNCHANGED, (Object)mergeResult);
        try {
            this.detector.checkConflict((Object)ArrayUtil.array((Object[])new Value[]{value}));
            Assert.fail((String)"Should've detected conflict");
        }
        catch (IndexEntryConflictException e) {
            Assert.assertEquals((long)entityId1, (long)e.getExistingNodeId());
            Assert.assertEquals((long)entityId2, (long)e.getAddedNodeId());
            Assert.assertEquals((Object)value, (Object)e.getSinglePropertyValue());
        }
    }

    @Test
    public void shouldNotReportConflictOnSameValueSameEntityId() throws IndexEntryConflictException {
        Value value = Values.of((Object)123);
        long entityId = 10L;
        ValueMerger.MergeResult mergeResult = this.detector.merge((NativeIndexKey)ThrowingConflictDetectorTest.key(entityId, value), (NativeIndexKey)ThrowingConflictDetectorTest.key(entityId, value), NativeIndexValue.INSTANCE, NativeIndexValue.INSTANCE);
        Assertions.assertSame((Object)ValueMerger.MergeResult.UNCHANGED, (Object)mergeResult);
        this.detector.checkConflict((Object)ArrayUtil.array((Object[])new Value[0]));
    }

    private static NumberIndexKey key(long entityId, Value value) {
        NumberIndexKey key = new NumberIndexKey();
        key.initialize(entityId);
        key.initFromValue(0, value, NativeIndexKey.Inclusion.LOW);
        return key;
    }
}

