/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneOffset;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.schema.ZonedTimeIndexKey;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class ZonedTimeIndexKeyTest {
    @Test
    public void compareToSameAsValue() {
        Value[] values = new Value[]{TimeValue.time((long)9999L, (ZoneOffset)ZoneOffset.of("+18:00")), TimeValue.time((long)10000L, (ZoneOffset)ZoneOffset.of("-18:00")), TimeValue.time((long)10000L, (ZoneOffset)ZoneOffset.of("-00:00")), TimeValue.time((long)10000L, (ZoneOffset)ZoneOffset.of("+01:00")), TimeValue.time((long)10000L, (ZoneOffset)ZoneOffset.of("+03:00")), TimeValue.time((long)10000L, (ZoneOffset)ZoneOffset.of("-18:00"))};
        ZonedTimeIndexKey keyI = new ZonedTimeIndexKey();
        ZonedTimeIndexKey keyJ = new ZonedTimeIndexKey();
        for (Value vi : values) {
            for (Value vj : values) {
                vi.writeTo((ValueWriter)keyI);
                vj.writeTo((ValueWriter)keyJ);
                int expected = Values.COMPARATOR.compare(vi, vj);
                Assert.assertEquals((String)String.format("comparing %s and %s", vi, vj), (long)expected, (long)keyI.compareValueTo(keyJ));
            }
        }
    }
}

