/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.ToMapSettingVisitor;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class IndexSpecificSpaceFillingCurveSettingsCacheTest {
    private final ConfiguredSpaceFillingCurveSettingsCache globalSettings = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());

    IndexSpecificSpaceFillingCurveSettingsCacheTest() {
    }

    @Test
    void shouldHaveInitialIndexSpecificSetting() {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> initialSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        initialSettings.put(CoordinateReferenceSystem.WGS84, this.globalSettings.forCRS(CoordinateReferenceSystem.WGS84));
        initialSettings.put(CoordinateReferenceSystem.Cartesian, this.globalSettings.forCRS(CoordinateReferenceSystem.Cartesian));
        IndexSpecificSpaceFillingCurveSettingsCache indexSettings = new IndexSpecificSpaceFillingCurveSettingsCache(this.globalSettings, initialSettings);
        ToMapSettingVisitor visitor = new ToMapSettingVisitor();
        indexSettings.visitIndexSpecificSettings((IndexSpecificSpaceFillingCurveSettingsCache.SettingVisitor)visitor);
        Assertions.assertEquals(initialSettings, visitor.map);
    }

    @Test
    void shouldHaveInitialIndexSpecificSettingsPlusRequestedOnes() {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> initialSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        initialSettings.put(CoordinateReferenceSystem.WGS84, this.globalSettings.forCRS(CoordinateReferenceSystem.WGS84));
        initialSettings.put(CoordinateReferenceSystem.Cartesian, this.globalSettings.forCRS(CoordinateReferenceSystem.Cartesian));
        IndexSpecificSpaceFillingCurveSettingsCache indexSettings = new IndexSpecificSpaceFillingCurveSettingsCache(this.globalSettings, initialSettings);
        indexSettings.forCrs(CoordinateReferenceSystem.Cartesian_3D, true);
        ToMapSettingVisitor visitor = new ToMapSettingVisitor();
        indexSettings.visitIndexSpecificSettings((IndexSpecificSpaceFillingCurveSettingsCache.SettingVisitor)visitor);
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> expectedSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>(initialSettings);
        Assertions.assertNull((Object)expectedSettings.put(CoordinateReferenceSystem.Cartesian_3D, this.globalSettings.forCRS(CoordinateReferenceSystem.Cartesian_3D)));
        Assertions.assertEquals(expectedSettings, visitor.map);
    }

    @Test
    void shouldNotCreateIndexSpecificSettingForReadRequest() {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> initialSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        initialSettings.put(CoordinateReferenceSystem.WGS84, this.globalSettings.forCRS(CoordinateReferenceSystem.WGS84));
        initialSettings.put(CoordinateReferenceSystem.Cartesian, this.globalSettings.forCRS(CoordinateReferenceSystem.Cartesian));
        IndexSpecificSpaceFillingCurveSettingsCache indexSettings = new IndexSpecificSpaceFillingCurveSettingsCache(this.globalSettings, initialSettings);
        indexSettings.forCrs(CoordinateReferenceSystem.Cartesian_3D, false);
        ToMapSettingVisitor visitor = new ToMapSettingVisitor();
        indexSettings.visitIndexSpecificSettings((IndexSpecificSpaceFillingCurveSettingsCache.SettingVisitor)visitor);
        Assertions.assertEquals(initialSettings, visitor.map);
    }
}

