/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsReader;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsWriter;
import org.neo4j.kernel.impl.index.schema.config.ToMapSettingVisitor;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpaceFillingCurveSettingsHeaderTest {
    private final byte[] data = new byte[8192];
    private final PageCursor pageCursor = ByteArrayPageCursor.wrap((byte[])this.data);

    SpaceFillingCurveSettingsHeaderTest() {
    }

    @Test
    void shouldWriteAndReadZeroSettings() {
        this.shouldWriteAndReadSettings(new CoordinateReferenceSystem[0]);
    }

    @Test
    void shouldWriteAndReadSingleSetting() {
        this.shouldWriteAndReadSettings(CoordinateReferenceSystem.WGS84);
    }

    @Test
    void shouldWriteAndReadMultipleSettings() {
        this.shouldWriteAndReadSettings(CoordinateReferenceSystem.WGS84, CoordinateReferenceSystem.Cartesian, CoordinateReferenceSystem.Cartesian_3D);
    }

    private void shouldWriteAndReadSettings(CoordinateReferenceSystem ... crss) {
        IndexSpecificSpaceFillingCurveSettingsCache indexSettings = new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), new HashMap());
        for (CoordinateReferenceSystem crs : crss) {
            indexSettings.forCrs(crs, true);
        }
        SpaceFillingCurveSettingsWriter writer = new SpaceFillingCurveSettingsWriter(indexSettings);
        writer.accept(this.pageCursor);
        this.pageCursor.rewind();
        HashMap read = new HashMap();
        SpaceFillingCurveSettingsReader reader = new SpaceFillingCurveSettingsReader(read);
        reader.read(ByteBuffer.wrap(this.data));
        Assertions.assertEquals(this.asMap(indexSettings), read);
    }

    private Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> asMap(IndexSpecificSpaceFillingCurveSettingsCache indexSettings) {
        ToMapSettingVisitor visitor = new ToMapSettingVisitor();
        indexSettings.visitIndexSpecificSettings((IndexSpecificSpaceFillingCurveSettingsCache.SettingVisitor)visitor);
        return visitor.map;
    }
}

