/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.EnumMap;
import java.util.function.Function;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class FusionIndexReaderTest {
    private IndexReader[] aliveReaders;
    private EnumMap<IndexSlot, IndexReader> readers;
    private FusionIndexReader fusionIndexReader;
    private static final int PROP_KEY = 1;
    private static final int LABEL_KEY = 11;
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        IndexSlot[] activeSlots = fusionVersion.aliveSlots();
        this.readers = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.readers, IndexReader.EMPTY);
        this.aliveReaders = new IndexReader[activeSlots.length];
        block7: for (int i = 0; i < activeSlots.length; ++i) {
            IndexReader mock;
            this.aliveReaders[i] = mock = (IndexReader)Mockito.mock(IndexReader.class);
            switch (activeSlots[i]) {
                case STRING: {
                    this.readers.put(IndexSlot.STRING, mock);
                    continue block7;
                }
                case NUMBER: {
                    this.readers.put(IndexSlot.NUMBER, mock);
                    continue block7;
                }
                case SPATIAL: {
                    this.readers.put(IndexSlot.SPATIAL, mock);
                    continue block7;
                }
                case TEMPORAL: {
                    this.readers.put(IndexSlot.TEMPORAL, mock);
                    continue block7;
                }
                case LUCENE: {
                    this.readers.put(IndexSlot.LUCENE, mock);
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexReader = new FusionIndexReader(fusionVersion.slotSelector(), new LazyInstanceSelector(this.readers, this.throwingFactory()), TestIndexDescriptorFactory.forLabel(11, 1));
    }

    private Function<IndexSlot, IndexReader> throwingFactory() {
        return i -> {
            throw new IllegalStateException("All readers should exist already");
        };
    }

    @Test
    public void closeMustCloseBothNativeAndLucene() {
        this.fusionIndexReader.close();
        for (IndexReader reader : this.aliveReaders) {
            ((IndexReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void closeIteratorMustCloseAll() throws Exception {
        PrimitiveLongResourceIterator[] iterators = new PrimitiveLongResourceIterator[this.aliveReaders.length];
        for (int i = 0; i < this.aliveReaders.length; ++i) {
            PrimitiveLongResourceIterator iterator = (PrimitiveLongResourceIterator)Mockito.mock(PrimitiveLongResourceIterator.class);
            Mockito.when((Object)this.aliveReaders[i].query(new IndexQuery[]{(IndexQuery)ArgumentMatchers.any(IndexQuery.class)})).thenReturn((Object)iterator);
            iterators[i] = iterator;
        }
        this.fusionIndexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)}).close();
        for (PrimitiveLongResourceIterator iterator : iterators) {
            ((PrimitiveLongResourceIterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void countIndexedNodesMustSelectCorrectReader() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyCountIndexedNodesWithCorrectReader(this.orLucene(this.readers.get(indexSlot)), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyCountIndexedNodesWithCorrectReader(this.readers.get(IndexSlot.LUCENE), new Value[]{indexSlot, secondValue});
            }
        }
    }

    private void verifyCountIndexedNodesWithCorrectReader(IndexReader correct, Value ... nativeValue) {
        this.fusionIndexReader.countIndexedNodes(0L, new int[]{1}, nativeValue);
        ((IndexReader)Mockito.verify((Object)correct, (VerificationMode)Mockito.times((int)1))).countIndexedNodes(0L, new int[]{1}, nativeValue);
        for (IndexReader reader : this.aliveReaders) {
            if (reader == correct) continue;
            ((IndexReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.never())).countIndexedNodes(0L, new int[]{1}, nativeValue);
        }
    }

    @Test
    public void mustSelectLuceneForCompositePredicate() throws Exception {
        this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.LUCENE), (IndexQuery)ArgumentMatchers.any(IndexQuery.class), (IndexQuery)ArgumentMatchers.any(IndexQuery.class));
    }

    @Test
    public void mustSelectStringForExactPredicateWithNumberValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesSupportedByString()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectNumberForExactPredicateWithNumberValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesSupportedByNumber()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.expectedForNumbers(), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectSpatialForExactPredicateWithSpatialValue() throws Exception {
        Assume.assumeTrue((boolean)this.hasSpatialSupport());
        for (Value value : FusionIndexTestHelp.valuesSupportedBySpatial()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.SPATIAL), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectTemporalForExactPredicateWithTemporalValue() throws Exception {
        Assume.assumeTrue((boolean)this.hasTemporalSupport());
        for (Value temporalValue : FusionIndexTestHelp.valuesSupportedByTemporal()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)temporalValue);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.TEMPORAL), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectLuceneForExactPredicateWithOtherValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesNotSupportedBySpecificIndex()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.LUCENE), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectStringForRangeStringPredicate() throws Exception {
        IndexQuery.RangePredicate stringRange = IndexQuery.range((int)1, (String)"abc", (boolean)true, (String)"def", (boolean)false);
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringRange});
    }

    @Test
    public void mustSelectNumberForRangeNumericPredicate() throws Exception {
        IndexQuery.RangePredicate numberRange = IndexQuery.range((int)1, (Number)0, (boolean)true, (Number)1, (boolean)false);
        this.verifyQueryWithCorrectReader(this.expectedForNumbers(), new IndexQuery[]{numberRange});
    }

    @Test
    public void mustSelectSpatialForRangeGeometricPredicate() throws Exception {
        Assume.assumeTrue((boolean)this.hasSpatialSupport());
        PointValue from = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        PointValue to = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.0, 2.0});
        IndexQuery.RangePredicate geometryRange = IndexQuery.range((int)1, (Value)from, (boolean)true, (Value)to, (boolean)false);
        this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.SPATIAL), new IndexQuery[]{geometryRange});
    }

    @Test
    public void mustSelectStringForStringPrefixPredicate() throws Exception {
        IndexQuery.StringPrefixPredicate stringPrefix = IndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"abc"));
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringPrefix});
    }

    @Test
    public void mustSelectStringForStringSuffixPredicate() throws Exception {
        IndexQuery.StringSuffixPredicate stringPrefix = IndexQuery.stringSuffix((int)1, (TextValue)Values.stringValue((String)"abc"));
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringPrefix});
    }

    @Test
    public void mustSelectStringForStringContainsPredicate() throws Exception {
        IndexQuery.StringContainsPredicate stringContains = IndexQuery.stringContains((int)1, (TextValue)Values.stringValue((String)"abc"));
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringContains});
    }

    @Test
    public void mustCombineResultFromExistsPredicate() throws Exception {
        IndexQuery.ExistsPredicate exists = IndexQuery.exists((int)1);
        long lastId = 0L;
        for (IndexReader aliveReader : this.aliveReaders) {
            Mockito.when((Object)aliveReader.query(new IndexQuery[]{exists})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{lastId++, lastId++}));
        }
        PrimitiveLongResourceIterator result = this.fusionIndexReader.query(new IndexQuery[]{exists});
        MutableLongSet resultSet = PrimitiveLongCollections.asSet((LongIterator)result);
        for (long i = 0L; i < lastId; ++i) {
            Assert.assertTrue((String)("Expected to contain " + i + ", but was " + resultSet), (boolean)resultSet.contains(i));
        }
    }

    @Test
    public void shouldInstantiatePartLazilyForSpecificValueGroupQuery() throws IndexNotApplicableKernelException {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot i : IndexSlot.values()) {
            if (this.readers.get(i) != IndexReader.EMPTY) {
                Value value = values.get(i)[0];
                this.fusionIndexReader.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)value)});
                for (IndexSlot j : IndexSlot.values()) {
                    if (this.readers.get(j) == IndexReader.EMPTY) continue;
                    if (i == j) {
                        ((IndexReader)Mockito.verify((Object)this.readers.get(i))).query(new IndexQuery[]{(IndexQuery)ArgumentMatchers.any(IndexQuery.class)});
                        continue;
                    }
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.readers.get(j)});
                }
            }
            this.initiateMocks();
        }
    }

    private void verifyQueryWithCorrectReader(IndexReader expectedReader, IndexQuery ... indexQuery) throws IndexNotApplicableKernelException {
        this.fusionIndexReader.query(indexQuery);
        ((IndexReader)Mockito.verify((Object)expectedReader, (VerificationMode)Mockito.times((int)1))).query(indexQuery);
        for (IndexReader reader : this.aliveReaders) {
            if (reader == expectedReader) continue;
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
        }
    }

    private IndexReader expectedForStrings() {
        return this.orLucene(this.readers.get(IndexSlot.STRING));
    }

    private IndexReader expectedForNumbers() {
        return this.orLucene(this.readers.get(IndexSlot.NUMBER));
    }

    private boolean hasSpatialSupport() {
        return this.readers.get(IndexSlot.SPATIAL) != IndexReader.EMPTY;
    }

    private boolean hasTemporalSupport() {
        return this.readers.get(IndexSlot.TEMPORAL) != IndexReader.EMPTY;
    }

    private IndexReader orLucene(IndexReader reader) {
        return reader != IndexReader.EMPTY ? reader : this.readers.get(IndexSlot.LUCENE);
    }
}

