/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.EnumMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;

class FusionSlotSelectorTest {
    FusionSlotSelectorTest() {
    }

    @Test
    void throwIfToFewInstances() {
        EnumMap<IndexSlot, IndexProvider> instances = new EnumMap<IndexSlot, IndexProvider>(IndexSlot.class);
        for (IndexSlot indexSlot : IndexSlot.values()) {
            instances.put(indexSlot, IndexProvider.EMPTY);
        }
        InstanceSelector instanceSelector = new InstanceSelector(instances);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SlotSelector.validateSelectorInstances((InstanceSelector)instanceSelector, (IndexSlot[])new IndexSlot[]{IndexSlot.NUMBER}));
    }

    @Test
    void throwIfToManyInstances() {
        EnumMap<IndexSlot, IndexProvider> instances = new EnumMap<IndexSlot, IndexProvider>(IndexSlot.class);
        for (IndexSlot indexSlot : IndexSlot.values()) {
            instances.put(indexSlot, IndexProvider.EMPTY);
        }
        IndexProvider mockedIndxProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
        instances.put(IndexSlot.NUMBER, mockedIndxProvider);
        InstanceSelector instanceSelector = new InstanceSelector(instances);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SlotSelector.validateSelectorInstances((InstanceSelector)instanceSelector, (IndexSlot[])new IndexSlot[0]));
    }

    @Test
    void shouldValidateSelectorInstances() {
        EnumMap<IndexSlot, IndexProvider> instances = new EnumMap<IndexSlot, IndexProvider>(IndexSlot.class);
        for (IndexSlot indexSlot : IndexSlot.values()) {
            instances.put(indexSlot, IndexProvider.EMPTY);
        }
        IndexProvider mockedIndxProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
        instances.put(IndexSlot.NUMBER, mockedIndxProvider);
        InstanceSelector selector = new InstanceSelector(instances);
        SlotSelector.validateSelectorInstances((InstanceSelector)selector, (IndexSlot[])new IndexSlot[]{IndexSlot.NUMBER});
    }
}

