/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;

public class LazyInstanceSelectorTest {
    @Test
    public void shouldInstantiateLazilyOnFirstSelect() {
        Function<IndexSlot, String> factory = this.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        for (IndexSlot slot : IndexSlot.values()) {
            for (IndexSlot candidate : IndexSlot.values()) {
                if (candidate.ordinal() < slot.ordinal()) {
                    ((Function)Mockito.verify(factory, (VerificationMode)Mockito.times((int)1))).apply(candidate);
                    selector.select(candidate);
                    ((Function)Mockito.verify(factory, (VerificationMode)Mockito.times((int)1))).apply(candidate);
                    continue;
                }
                if (candidate == slot) {
                    ((Function)Mockito.verify(factory, (VerificationMode)Mockito.times((int)0))).apply(candidate);
                    selector.select(candidate);
                    ((Function)Mockito.verify(factory, (VerificationMode)Mockito.times((int)1))).apply(candidate);
                    continue;
                }
                Assert.assertNull((Object)selector.getIfInstantiated(candidate));
            }
        }
    }

    @Test
    public void shouldPerformActionOnAll() {
        Function<IndexSlot, String> factory = this.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        selector.select(IndexSlot.STRING);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        selector.forAll(consumer);
        for (IndexSlot slot : IndexSlot.values()) {
            ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept(String.valueOf(slot));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    public void shouldCloseAllInstantiated() {
        Function<IndexSlot, String> factory = this.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        selector.select(IndexSlot.NUMBER);
        selector.select(IndexSlot.STRING);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        selector.close(consumer);
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept(String.valueOf(IndexSlot.NUMBER));
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept(String.valueOf(IndexSlot.STRING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    public void shouldPreventInstantiationAfterClose() {
        Function<IndexSlot, String> factory = this.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        selector.select(IndexSlot.NUMBER);
        selector.select(IndexSlot.STRING);
        selector.close((Consumer)Mockito.mock(Consumer.class));
        try {
            selector.select(IndexSlot.TEMPORAL);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Function<IndexSlot, String> slotToStringFunction() {
        Function factory = (Function)Mockito.mock(Function.class);
        Mockito.when(factory.apply(ArgumentMatchers.any(IndexSlot.class))).then(invocationOnMock -> String.valueOf((IndexSlot)invocationOnMock.getArgument(0)));
        return factory;
    }
}

