/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.LockingNodeUniqueIndexSeek;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LockingNodeUniqueIndexSeekTest {
    private final int labelId = 1;
    private final int propertyKeyId = 2;
    private IndexReference index = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2}));
    private final Value value = Values.of((Object)"value");
    private final IndexQuery.ExactPredicate predicate = IndexQuery.exact((int)2, (Object)this.value);
    private final long resourceId = ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{this.predicate});
    private LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker<NodeValueIndexCursor> uniqueNodeIndexSeeker = (LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker)Mockito.mock(LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker.class);
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final Read read = (Read)Mockito.mock(Read.class);
    private InOrder order;

    @Before
    public void setup() {
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks});
    }

    @Test
    public void shouldHoldSharedIndexLockIfNodeIsExists() throws Exception {
        NodeValueIndexCursor cursor = (NodeValueIndexCursor)Mockito.mock(NodeValueIndexCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)true);
        Mockito.when((Object)cursor.nodeReference()).thenReturn((Object)42L);
        long nodeId = LockingNodeUniqueIndexSeek.apply((Locks.Client)this.locks, (LockTracer)LockTracer.NONE, () -> cursor, this.uniqueNodeIndexSeeker, (Read)this.read, (IndexReference)this.index, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{this.predicate});
        Assert.assertEquals((long)42L, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((NodeValueIndexCursor)Mockito.verify((Object)cursor)).close();
    }

    @Test
    public void shouldHoldSharedIndexLockIfNodeIsConcurrentlyCreated() throws Exception {
        NodeValueIndexCursor cursor = (NodeValueIndexCursor)Mockito.mock(NodeValueIndexCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Mockito.when((Object)cursor.nodeReference()).thenReturn((Object)42L);
        long nodeId = LockingNodeUniqueIndexSeek.apply((Locks.Client)this.locks, (LockTracer)LockTracer.NONE, () -> cursor, this.uniqueNodeIndexSeeker, (Read)this.read, (IndexReference)this.index, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{this.predicate});
        Assert.assertEquals((long)42L, (long)nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseShared((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((NodeValueIndexCursor)Mockito.verify((Object)cursor)).close();
    }

    @Test
    public void shouldHoldExclusiveIndexLockIfNodeDoesNotExist() throws Exception {
        NodeValueIndexCursor cursor = (NodeValueIndexCursor)Mockito.mock(NodeValueIndexCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)false, (Object[])new Boolean[]{false});
        Mockito.when((Object)cursor.nodeReference()).thenReturn((Object)-1L);
        long nodeId = LockingNodeUniqueIndexSeek.apply((Locks.Client)this.locks, (LockTracer)LockTracer.NONE, () -> cursor, this.uniqueNodeIndexSeeker, (Read)this.read, (IndexReference)this.index, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{this.predicate});
        Assert.assertEquals((long)-1L, (long)nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseShared((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((NodeValueIndexCursor)Mockito.verify((Object)cursor)).close();
    }
}

