/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.kernel.impl.newapi.TxStateIndexChanges;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class TxStateIndexChangesTest {
    private final IndexDescriptor index = TestIndexDescriptorFactory.forLabel(1, 1);

    TxStateIndexChangesTest() {
    }

    @Test
    void shouldComputeIndexUpdatesForScanOnAnEmptyTxState() {
        ReadableTransactionState state = (ReadableTransactionState)Mockito.mock(ReadableTransactionState.class);
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        Assert.assertTrue((boolean)changes.isEmpty());
        Assert.assertTrue((boolean)changesWithValues.isEmpty());
    }

    @Test
    void shouldComputeIndexUpdatesForScanWhenThereAreNewNodes() {
        ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "foo").withAdded(43L, "bar").build();
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        this.assertContains(changes.getAdded(), 42L, 43L);
        this.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.nodeWithPropertyValues(42L, "foo"), TxStateIndexChangesTest.nodeWithPropertyValues(43L, "bar"));
    }

    @Test
    void shouldComputeIndexUpdatesForScan() {
        this.assertScanWithOrder(IndexOrder.NONE);
        this.assertScanWithOrder(IndexOrder.ASCENDING);
    }

    @Test
    void shouldComputeIndexUpdatesForScanWithDescendingOrder() {
        this.assertScanWithOrder(IndexOrder.DESCENDING);
    }

    private void assertScanWithOrder(IndexOrder indexOrder) {
        ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Barbarella").withAdded(44L, "Andrea").withAdded(45L, "Aristotle").withAdded(46L, "Barbara").withAdded(47L, "Cinderella").build();
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)indexOrder);
        TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)indexOrder);
        NodeWithPropertyValues[] expectedNodesWithValues = new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(40L, "Aaron"), TxStateIndexChangesTest.nodeWithPropertyValues(41L, "Agatha"), TxStateIndexChangesTest.nodeWithPropertyValues(44L, "Andrea"), TxStateIndexChangesTest.nodeWithPropertyValues(42L, "Andreas"), TxStateIndexChangesTest.nodeWithPropertyValues(45L, "Aristotle"), TxStateIndexChangesTest.nodeWithPropertyValues(46L, "Barbara"), TxStateIndexChangesTest.nodeWithPropertyValues(43L, "Barbarella"), TxStateIndexChangesTest.nodeWithPropertyValues(47L, "Cinderella")};
        this.assertContains(indexOrder, changes, changesWithValues, expectedNodesWithValues);
    }

    @Test
    void shouldComputeIndexUpdatesForSeekWhenThereAreNewNodes() {
        ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "foo").withAdded(43L, "bar").build();
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.index, (ValueTuple)ValueTuple.of((Object[])new Object[]{"bar"}));
        this.assertContains(changes.getAdded(), 43L);
    }

    @TestFactory
    Collection<DynamicTest> rangeTests() {
        ReadableTransactionState state = new TxStateBuilder().withAdded(42L, 510).withAdded(43L, 520).withAdded(44L, 550).withAdded(45L, 500).withAdded(46L, 530).withAdded(47L, 560).withAdded(48L, 540).build();
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        tests.addAll(this.rangeTest(state, Values.of((Object)510), true, Values.of((Object)550), true, TxStateIndexChangesTest.nodeWithPropertyValues(42L, 510), TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540), TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, Values.of((Object)510), true, Values.of((Object)550), false, TxStateIndexChangesTest.nodeWithPropertyValues(42L, 510), TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, Values.of((Object)510), false, Values.of((Object)550), true, TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540), TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, Values.of((Object)510), false, Values.of((Object)550), false, TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, null, false, Values.of((Object)550), true, TxStateIndexChangesTest.nodeWithPropertyValues(45L, 500), TxStateIndexChangesTest.nodeWithPropertyValues(42L, 510), TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540), TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, null, true, Values.of((Object)550), true, TxStateIndexChangesTest.nodeWithPropertyValues(45L, 500), TxStateIndexChangesTest.nodeWithPropertyValues(42L, 510), TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540), TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, null, false, Values.of((Object)550), false, TxStateIndexChangesTest.nodeWithPropertyValues(45L, 500), TxStateIndexChangesTest.nodeWithPropertyValues(42L, 510), TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, null, true, Values.of((Object)550), false, TxStateIndexChangesTest.nodeWithPropertyValues(45L, 500), TxStateIndexChangesTest.nodeWithPropertyValues(42L, 510), TxStateIndexChangesTest.nodeWithPropertyValues(43L, 520), TxStateIndexChangesTest.nodeWithPropertyValues(46L, 530), TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), true, null, true, TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540), TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550), TxStateIndexChangesTest.nodeWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), true, null, false, TxStateIndexChangesTest.nodeWithPropertyValues(48L, 540), TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550), TxStateIndexChangesTest.nodeWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), false, null, true, TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550), TxStateIndexChangesTest.nodeWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), false, null, false, TxStateIndexChangesTest.nodeWithPropertyValues(44L, 550), TxStateIndexChangesTest.nodeWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)560), false, Values.of((Object)800), true, new NodeWithPropertyValues[0]));
        return tests;
    }

    private Collection<DynamicTest> rangeTest(ReadableTransactionState state, Value lo, boolean includeLo, Value hi, boolean includeHi, NodeWithPropertyValues ... expected) {
        return Arrays.asList(this.rangeTest(state, IndexOrder.NONE, lo, includeLo, hi, includeHi, expected), this.rangeTest(state, IndexOrder.ASCENDING, lo, includeLo, hi, includeHi, expected), this.rangeTest(state, IndexOrder.DESCENDING, lo, includeLo, hi, includeHi, expected));
    }

    private DynamicTest rangeTest(ReadableTransactionState state, IndexOrder indexOrder, Value lo, boolean includeLo, Value hi, boolean includeHi, NodeWithPropertyValues ... expected) {
        return DynamicTest.dynamicTest((String)String.format("range seek: lo=%s (incl: %s), hi=%s (incl: %s)", lo, includeLo, hi, includeHi), () -> {
            assert (lo != Values.NO_VALUE);
            assert (hi != Values.NO_VALUE);
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexQuery.RangePredicate)IndexQuery.range((int)-1, (Value)lo, (boolean)includeLo, (Value)hi, (boolean)includeHi), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexQuery.RangePredicate)IndexQuery.range((int)-1, (Value)lo, (boolean)includeLo, (Value)hi, (boolean)includeHi), (IndexOrder)indexOrder);
            this.assertContains(indexOrder, changes, changesWithValues, expected);
        });
    }

    private void assertContains(IndexOrder indexOrder, TxStateIndexChanges.AddedAndRemoved changes, TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues, NodeWithPropertyValues[] expected) {
        if (indexOrder == IndexOrder.DESCENDING) {
            ArrayUtils.reverse((Object[])expected);
        }
        long[] expectedNodeIds = Arrays.stream(expected).mapToLong(NodeWithPropertyValues::getNodeId).toArray();
        if (indexOrder == IndexOrder.NONE) {
            this.assertContains(changes.getAdded(), expectedNodeIds);
            this.assertContains(changesWithValues.getAdded(), expected);
        } else {
            this.assertContainsInOrder(changes.getAdded(), expectedNodeIds);
            this.assertContainsInOrder(changesWithValues.getAdded(), expected);
        }
    }

    private static NodeWithPropertyValues nodeWithPropertyValues(long nodeId, Object ... values) {
        return new NodeWithPropertyValues(nodeId, (Value[])Arrays.stream(values).map(ValueUtils::of).toArray(Value[]::new));
    }

    private void assertContains(LongIterable iterable, long ... nodeIds) {
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])nodeIds), (Object)LongSets.immutable.ofAll(iterable));
    }

    private void assertContains(Iterable<NodeWithPropertyValues> iterable, NodeWithPropertyValues ... expected) {
        Assert.assertEquals((Object)UnifiedSet.newSetWith((Object[])expected), (Object)UnifiedSet.newSet(iterable));
    }

    private void assertContainsInOrder(LongIterable iterable, long ... nodeIds) {
        MatcherAssert.assertThat(Arrays.asList(new long[][]{iterable.toArray()}), (Matcher)Matchers.contains((Object[])new long[][]{nodeIds}));
    }

    private void assertContainsInOrder(Iterable<NodeWithPropertyValues> iterable, NodeWithPropertyValues ... expected) {
        if (expected.length == 0) {
            MatcherAssert.assertThat(iterable, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat(iterable, (Matcher)Matchers.contains((Object[])expected));
        }
    }

    private static class TxStateBuilder {
        Map<ValueTuple, MutableLongDiffSetsImpl> updates = new HashMap<ValueTuple, MutableLongDiffSetsImpl>();

        private TxStateBuilder() {
        }

        TxStateBuilder withAdded(long id, Object ... value) {
            ValueTuple valueTuple = ValueTuple.of((Object[])value);
            MutableLongDiffSetsImpl changes = this.updates.computeIfAbsent(valueTuple, ignore -> new MutableLongDiffSetsImpl(OnHeapCollectionsFactory.INSTANCE));
            changes.add(id);
            return this;
        }

        TxStateBuilder withRemoved(long id, Object ... value) {
            ValueTuple valueTuple = ValueTuple.of((Object[])value);
            MutableLongDiffSetsImpl changes = this.updates.computeIfAbsent(valueTuple, ignore -> new MutableLongDiffSetsImpl(OnHeapCollectionsFactory.INSTANCE));
            changes.remove(id);
            return this;
        }

        ReadableTransactionState build() {
            ReadableTransactionState mock = (ReadableTransactionState)Mockito.mock(ReadableTransactionState.class);
            ((ReadableTransactionState)Mockito.doReturn((Object)new UnmodifiableMap(this.updates)).when((Object)mock)).getIndexUpdates((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class));
            TreeMap<ValueTuple, MutableLongDiffSetsImpl> sortedMap = new TreeMap<ValueTuple, MutableLongDiffSetsImpl>(ValueTuple.COMPARATOR);
            sortedMap.putAll(this.updates);
            ((ReadableTransactionState)Mockito.doReturn(sortedMap).when((Object)mock)).getSortedIndexUpdates((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class));
            return mock;
        }
    }

    @Nested
    class CompositeIndex {
        private final IndexDescriptor compositeIndex = TestIndexDescriptorFactory.forLabel(1, 1, 2);

        CompositeIndex() {
        }

        @Test
        void shouldSeekOnAnEmptyTxState() {
            ReadableTransactionState state = (ReadableTransactionState)Mockito.mock(ReadableTransactionState.class);
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
            Assert.assertTrue((boolean)changes.isEmpty());
        }

        @Test
        void shouldScanWhenThereAreNewNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{42L, 43L});
            TxStateIndexChangesTest.this.assertContains(changesWithValues.getAdded(), new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(42L, new Object[]{"42value1", "42value2"}), TxStateIndexChangesTest.nodeWithPropertyValues(43L, new Object[]{"43value1", "43value2"})});
        }

        @Test
        void shouldSeekWhenThereAreNewStringNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{43L});
        }

        @Test
        void shouldSeekWhenThereAreNewNumberNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, 42001.0, 42002.0).withAdded(43L, 43001.0, 43002.0).build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{43001.0, 43002.0}));
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{43L});
        }

        @Test
        void shouldHandleMixedAddsAndRemovesEntry() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").withRemoved(43L, "43value1", "43value2").withRemoved(44L, "44value1", "44value2").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{42L});
            TxStateIndexChangesTest.this.assertContains(changesWithValues.getAdded(), new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(42L, new Object[]{"42value1", "42value2"})});
            TxStateIndexChangesTest.this.assertContains((LongIterable)changes.getRemoved(), new long[]{44L});
            TxStateIndexChangesTest.this.assertContains((LongIterable)changesWithValues.getRemoved(), new long[]{44L});
        }

        @Test
        void shouldSeekWhenThereAreManyEntriesWithTheSameValues() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").withAdded(44L, "43value1", "43value2").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{43L, 44L});
        }

        @Test
        void shouldSeekInComplexMix() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(10L, "hi", 3).withAdded(11L, 9L, 33L).withAdded(12L, "sneaker", false).withAdded(13L, new int[]{10, 100}, "array-buddy").withAdded(14L, 40.1, 40.2).build();
            TxStateIndexChangesTest.this.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"hi", 3})).getAdded(), new long[]{10L});
            TxStateIndexChangesTest.this.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{9L, 33L})).getAdded(), new long[]{11L});
            TxStateIndexChangesTest.this.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"sneaker", false})).getAdded(), new long[]{12L});
            TxStateIndexChangesTest.this.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{new int[]{10, 100}, "array-buddy"})).getAdded(), new long[]{13L});
            TxStateIndexChangesTest.this.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{40.1, 40.2})).getAdded(), new long[]{14L});
        }
    }

    @Nested
    class Prefix {
        Prefix() {
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNoMatchingNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "value42").withAdded(43L, "value43").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (TextValue)Values.stringValue((String)"eulav"), (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (TextValue)Values.stringValue((String)"eulav"), (IndexOrder)IndexOrder.NONE);
            Assert.assertTrue((boolean)changes.getAdded().isEmpty());
            Assert.assertFalse((boolean)changesWithValues.getAdded().iterator().hasNext());
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefix() {
            this.assertRangeSeekByPrefixForOrder(IndexOrder.NONE);
            this.assertRangeSeekByPrefixForOrder(IndexOrder.ASCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefixWithDescendingOrder() {
            this.assertRangeSeekByPrefixForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekByPrefixForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Barbarella").withAdded(44L, "Andrea").withAdded(45L, "Aristotle").withAdded(46L, "Barbara").withAdded(47L, "Andy").withAdded(48L, "Cinderella").withAdded(49L, "Andromeda").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (TextValue)Values.stringValue((String)"And"), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (TextValue)Values.stringValue((String)"And"), (IndexOrder)indexOrder);
            NodeWithPropertyValues[] expected = new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(44L, new Object[]{"Andrea"}), TxStateIndexChangesTest.nodeWithPropertyValues(42L, new Object[]{"Andreas"}), TxStateIndexChangesTest.nodeWithPropertyValues(49L, new Object[]{"Andromeda"}), TxStateIndexChangesTest.nodeWithPropertyValues(47L, new Object[]{"Andy"})};
            TxStateIndexChangesTest.this.assertContains(indexOrder, changes, changesWithValues, expected);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNonStringNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "barry").withAdded(44L, 101L).withAdded(43L, "bar").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (TextValue)Values.stringValue((String)"bar"), (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.this.assertContainsInOrder(changes.getAdded(), new long[]{43L, 42L});
        }
    }

    @Nested
    class SuffixOrContains {
        SuffixOrContains() {
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByContainsWhenThereAreNoMatchingNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "foo").withAdded(43L, "bar").build();
            IndexQuery.StringContainsPredicate indexQuery = IndexQuery.stringContains((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"eulav"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            Assert.assertTrue((boolean)changes.getAdded().isEmpty());
            Assert.assertFalse((boolean)changesWithValues.getAdded().iterator().hasNext());
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekBySuffixWhenThereArePartiallyMatchingNewNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Andrea").withAdded(44L, "Aristotle").withAdded(45L, "Barbara").withAdded(46L, "Barbarella").withAdded(47L, "Cinderella").build();
            IndexQuery.StringSuffixPredicate indexQuery = IndexQuery.stringSuffix((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"ella"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{46L, 47L});
            TxStateIndexChangesTest.this.assertContains(changesWithValues.getAdded(), new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(46L, new Object[]{"Barbarella"}), TxStateIndexChangesTest.nodeWithPropertyValues(47L, new Object[]{"Cinderella"})});
        }

        @Test
        void shouldComputeIndexUpdatesForSuffixWithAscendingOrder() {
            this.assertRangeSeekBySuffixForOrder(IndexOrder.ASCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForSuffixWithDescendingOrder() {
            this.assertRangeSeekBySuffixForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekBySuffixForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Bonbon").withAdded(42L, "Crayfish").withAdded(43L, "Mayonnaise").withAdded(44L, "Seashell").withAdded(45L, "Ton").withAdded(46L, "Macron").withAdded(47L, "Tony").withAdded(48L, "Evon").withAdded(49L, "Andromeda").build();
            IndexQuery.StringSuffixPredicate indexQuery = IndexQuery.stringSuffix((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"on"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)indexOrder);
            NodeWithPropertyValues[] expected = new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(40L, new Object[]{"Aaron"}), TxStateIndexChangesTest.nodeWithPropertyValues(41L, new Object[]{"Bonbon"}), TxStateIndexChangesTest.nodeWithPropertyValues(48L, new Object[]{"Evon"}), TxStateIndexChangesTest.nodeWithPropertyValues(46L, new Object[]{"Macron"}), TxStateIndexChangesTest.nodeWithPropertyValues(45L, new Object[]{"Ton"})};
            TxStateIndexChangesTest.this.assertContains(indexOrder, changes, changesWithValues, expected);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByContainsWhenThereArePartiallyMatchingNewNodes() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Andrea").withAdded(44L, "Aristotle").withAdded(45L, "Barbara").withAdded(46L, "Barbarella").withAdded(47L, "Cinderella").build();
            IndexQuery.StringContainsPredicate indexQuery = IndexQuery.stringContains((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"arbar"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.this.assertContains(changes.getAdded(), new long[]{45L, 46L});
            TxStateIndexChangesTest.this.assertContains(changesWithValues.getAdded(), new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(45L, new Object[]{"Barbara"}), TxStateIndexChangesTest.nodeWithPropertyValues(46L, new Object[]{"Barbarella"})});
        }

        @Test
        void shouldComputeIndexUpdatesForContainsWithAscendingOrder() {
            this.assertRangeSeekByContainsForOrder(IndexOrder.ASCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForContainsWithDescendingOrder() {
            this.assertRangeSeekByContainsForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekByContainsForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Smashing").withAdded(41L, "Bashley").withAdded(42L, "Crasch").withAdded(43L, "Mayonnaise").withAdded(44L, "Seashell").withAdded(45L, "Ton").withAdded(46L, "The Flash").withAdded(47L, "Strayhound").withAdded(48L, "Trashy").withAdded(49L, "Andromeda").build();
            IndexQuery.StringContainsPredicate indexQuery = IndexQuery.stringContains((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"ash"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (IndexQuery)indexQuery, (IndexOrder)indexOrder);
            NodeWithPropertyValues[] expected = new NodeWithPropertyValues[]{TxStateIndexChangesTest.nodeWithPropertyValues(41L, new Object[]{"Bashley"}), TxStateIndexChangesTest.nodeWithPropertyValues(44L, new Object[]{"Seashell"}), TxStateIndexChangesTest.nodeWithPropertyValues(40L, new Object[]{"Smashing"}), TxStateIndexChangesTest.nodeWithPropertyValues(46L, new Object[]{"The Flash"}), TxStateIndexChangesTest.nodeWithPropertyValues(48L, new Object[]{"Trashy"})};
            TxStateIndexChangesTest.this.assertContains(indexOrder, changes, changesWithValues, expected);
        }
    }
}

