/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.kernel.impl.proc.MapConverter;

public class MapConverterTest {
    private final MapConverter converter = new MapConverter();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldHandleNullString() {
        String mapString = "null";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap(null)));
    }

    @Test
    public void shouldHandleEmptyMap() {
        String mapString = "{}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap(Collections.emptyMap())));
    }

    @Test
    public void shouldHandleEmptyMapWithSpaces() {
        String mapString = " {  }  ";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap(Collections.emptyMap())));
    }

    @Test
    public void shouldHandleSingleQuotedValue() {
        String mapString = "{key: 'value'}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "value"}))));
    }

    @Test
    public void shouldHandleEscapedSingleQuotedInValue1() {
        String mapString = "{key: 'va'lue'}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "va'lue"}))));
    }

    @Test
    public void shouldHandleEscapedSingleQuotedInValue2() {
        String mapString = "{key: \"va'lue\"}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "va'lue"}))));
    }

    @Test
    public void shouldHandleEscapedDoubleQuotedInValue1() {
        String mapString = "{key: \"va\"lue\"}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "va\"lue"}))));
    }

    @Test
    public void shouldHandleEscapedDoubleQuotedInValue2() {
        String mapString = "{key: 'va\"lue'}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "va\"lue"}))));
    }

    @Test
    public void shouldHandleDoubleQuotedValue() {
        String mapString = "{key: \"value\"}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "value"}))));
    }

    @Test
    public void shouldHandleSingleQuotedKey() {
        String mapString = "{'key;: 'value'}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "value"}))));
    }

    @Test
    public void shouldHandleDoubleQuotedKey() {
        String mapString = "{\"key\": \"value\"}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", "value"}))));
    }

    @Test
    public void shouldHandleKeyWithEscapedSingleQuote() {
        String mapString = "{\"k'ey\": \"value\"}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"k'ey", "value"}))));
    }

    @Test
    public void shouldHandleKeyWithEscapedDoubleQuote() {
        String mapString = "{\"k\"ey\": \"value\"}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"k\"ey", "value"}))));
    }

    @Test
    public void shouldHandleIntegerValue() {
        String mapString = "{key: 1337}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", 1337L}))));
    }

    @Test
    public void shouldHandleFloatValue() {
        String mapString = "{key: 2.718281828}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", 2.718281828}))));
    }

    @Test
    public void shouldHandleNullValue() {
        String mapString = "{key: null}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", null}))));
    }

    @Test
    public void shouldHandleFalseValue() {
        String mapString = "{key: false}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", false}))));
    }

    @Test
    public void shouldHandleTrueValue() {
        String mapString = "{key: true}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"key", true}))));
    }

    @Test
    public void shouldHandleMultipleKeys() {
        String mapString = "{k1: 2.718281828, k2: 'e'}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntMap((Map)MapUtil.map((Object[])new Object[]{"k1", 2.718281828, "k2", "e"}))));
    }

    @Test
    public void shouldFailWhenDuplicateKey() {
        String mapString = "{k1: 2.718281828, k1: 'e'}";
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Multiple occurrences of key 'k1'");
        this.converter.apply(mapString);
    }

    @Test
    public void shouldHandleNestedMaps() {
        String mapString = "{k1: 1337, k2: { k1 : 1337, k2: {k1: 1337}}}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Map map1 = (Map)converted.value();
        Map map2 = (Map)map1.get("k2");
        Map map3 = (Map)map2.get("k2");
        Assert.assertThat(map1.get("k1"), (Matcher)CoreMatchers.equalTo((Object)1337L));
        Assert.assertThat(map2.get("k1"), (Matcher)CoreMatchers.equalTo((Object)1337L));
        Assert.assertThat(map3.get("k1"), (Matcher)CoreMatchers.equalTo((Object)1337L));
    }

    @Test
    public void shouldFailOnMalformedMap() {
        String mapString = "{k1: 2.718281828, k2: 'e'}}";
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("{k1: 2.718281828, k2: 'e'}} contains unbalanced '{', '}'.");
        this.converter.apply(mapString);
    }

    @Test
    public void shouldHandleMapsWithLists() {
        String mapString = "{k1: [1337, 42]}";
        DefaultParameterValue converted = this.converter.apply(mapString);
        Map map1 = (Map)converted.value();
        Assert.assertThat(map1.get("k1"), (Matcher)CoreMatchers.equalTo(Arrays.asList(1337L, 42L)));
    }
}

