/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.JarBuilder;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureJarLoader;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class ProcedureJarLoaderTest {
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Log log = (Log)Mockito.mock(Log.class);
    private final ProcedureJarLoader jarloader = new ProcedureJarLoader(new ReflectiveProcedureCompiler(new TypeMappers(), new ComponentRegistry(), this.registryWithUnsafeAPI(), this.log, this.procedureConfig()), (Log)NullLog.getInstance());
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void shouldLoadProcedureFromJar() throws Throwable {
        URL jar = this.createJarFor(ClassWithOneProcedure.class);
        List procedures = this.jarloader.loadProceduresFromDir(this.parentDir(jar)).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.contains((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)((CallableProcedure)procedures.get(0)).apply((Context)new BasicContext(), new Object[0], this.resourceTracker)), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{1337L})));
    }

    @Test
    public void shouldLoadProcedureFromJarWithSpacesInFilename() throws Throwable {
        URL jar = new JarBuilder().createJarFor(this.tmpdir.newFile(new Random().nextInt() + " some spaces in filename.jar"), ClassWithOneProcedure.class);
        List procedures = this.jarloader.loadProceduresFromDir(this.parentDir(jar)).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.contains((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)((CallableProcedure)procedures.get(0)).apply((Context)new BasicContext(), new Object[0], this.resourceTracker)), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{1337L})));
    }

    @Test
    public void shouldLoadProcedureWithArgumentFromJar() throws Throwable {
        URL jar = this.createJarFor(ClassWithProcedureWithArgument.class);
        List procedures = this.jarloader.loadProceduresFromDir(this.parentDir(jar)).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.contains((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).in("value", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)((CallableProcedure)procedures.get(0)).apply((Context)new BasicContext(), new Object[]{42L}, this.resourceTracker)), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{42L})));
    }

    @Test
    public void shouldLoadProcedureFromJarWithMultipleProcedureClasses() throws Throwable {
        URL jar = this.createJarFor(ClassWithOneProcedure.class, ClassWithAnotherProcedure.class, ClassWithNoProcedureAtAll.class);
        List procedures = this.jarloader.loadProceduresFromDir(this.parentDir(jar)).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myOtherProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnInvalidProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithOneProcedure.class, ClassWithInvalidProcedure.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `boolean`, you could define a record class like:%npublic class Output '{'%n    public boolean out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[0]));
        this.jarloader.loadProceduresFromDir(this.parentDir(jar));
    }

    @Test
    public void shouldLoadProceduresFromDirectory() throws Throwable {
        this.createJarFor(ClassWithOneProcedure.class);
        this.createJarFor(ClassWithAnotherProcedure.class);
        List procedures = this.jarloader.loadProceduresFromDir(this.tmpdir.getRoot()).procedures();
        List signatures = procedures.stream().map(CallableProcedure::signature).collect(Collectors.toList());
        Assert.assertThat(signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myOtherProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "myProcedure"}).out("someNumber", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnWildCardProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithWildCardStream.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a Stream<?>.", new Object[0]));
        this.jarloader.loadProceduresFromDir(this.parentDir(jar));
    }

    @Test
    public void shouldGiveHelpfulErrorOnRawStreamProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithRawStream.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a raw Stream.", new Object[0]));
        this.jarloader.loadProceduresFromDir(this.parentDir(jar));
    }

    @Test
    public void shouldGiveHelpfulErrorOnGenericStreamProcedure() throws Throwable {
        URL jar = this.createJarFor(ClassWithGenericStream.class);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a parameterized type such as java.util.List<org.neo4j.kernel.impl.proc.ProcedureJarLoaderTest$Output>.", new Object[0]));
        this.jarloader.loadProceduresFromDir(this.parentDir(jar));
    }

    @Test
    public void shouldLogHelpfullyWhenPluginJarIsCorrupt() throws Exception {
        URL theJar = this.createJarFor(ClassWithOneProcedure.class, ClassWithAnotherProcedure.class, ClassWithNoProcedureAtAll.class);
        this.corruptJar(theJar);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        ProcedureJarLoader jarloader = new ProcedureJarLoader(new ReflectiveProcedureCompiler(new TypeMappers(), new ComponentRegistry(), this.registryWithUnsafeAPI(), this.log, this.procedureConfig()), logProvider.getLog(ProcedureJarLoader.class));
        try {
            jarloader.loadProceduresFromDir(this.parentDir(theJar));
            Assert.fail((String)"Should have logged and thrown exception.");
        }
        catch (ZipException expected) {
            logProvider.internalToStringMessageMatcher().assertContains(StringEscapeUtils.escapeJava((String)String.format("Plugin jar file: %s corrupted.", new File(theJar.toURI()).toPath())));
        }
    }

    @Test
    public void shouldWorkOnPathsWithSpaces() throws Exception {
        File fileWithSpacesInName = this.tmpdir.newFile(new Random().nextInt() + "  some spaces in the filename.jar");
        URL theJar = new JarBuilder().createJarFor(fileWithSpacesInName, ClassWithOneProcedure.class);
        this.corruptJar(theJar);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        ProcedureJarLoader jarloader = new ProcedureJarLoader(new ReflectiveProcedureCompiler(new TypeMappers(), new ComponentRegistry(), this.registryWithUnsafeAPI(), this.log, this.procedureConfig()), logProvider.getLog(ProcedureJarLoader.class));
        try {
            jarloader.loadProceduresFromDir(this.parentDir(theJar));
            Assert.fail((String)"Should have logged and thrown exception.");
        }
        catch (ZipException expected) {
            logProvider.internalToStringMessageMatcher().assertContains(StringEscapeUtils.escapeJava((String)String.format("Plugin jar file: %s corrupted.", fileWithSpacesInName.toPath())));
        }
    }

    @Test
    public void shouldReturnEmptySetOnNullArgument() throws Exception {
        ProcedureJarLoader jarloader = new ProcedureJarLoader(new ReflectiveProcedureCompiler(new TypeMappers(), new ComponentRegistry(), this.registryWithUnsafeAPI(), this.log, this.procedureConfig()), (Log)NullLog.getInstance());
        ProcedureJarLoader.Callables callables = jarloader.loadProceduresFromDir(null);
        Assert.assertEquals((long)0L, (long)(callables.procedures().size() + callables.functions().size()));
    }

    private File parentDir(URL jar) {
        return new File(jar.getFile()).getParentFile();
    }

    private void corruptJar(URL jar) throws IOException, URISyntaxException {
        File jarFile = new File(jar.toURI()).getCanonicalFile();
        long fileLength = jarFile.length();
        byte[] bytes = Files.readAllBytes(Paths.get(jar.toURI()));
        for (long i = fileLength / 2L; i < fileLength; ++i) {
            bytes[(int)i] = 0;
        }
        Files.write(jarFile.toPath(), bytes, new OpenOption[0]);
    }

    private URL createJarFor(Class<?> ... targets) throws IOException {
        return new JarBuilder().createJarFor(this.tmpdir.newFile(new Random().nextInt() + ".jar"), targets);
    }

    private ComponentRegistry registryWithUnsafeAPI() {
        ComponentRegistry allComponents = new ComponentRegistry();
        allComponents.register(UnsafeAPI.class, ctx -> new UnsafeAPI());
        return allComponents;
    }

    private ProcedureConfig procedureConfig() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.procedure_unrestricted, (String)"org.neo4j.kernel.impl.proc.unsafeFullAccess*");
        return new ProcedureConfig(config);
    }

    private static class UnsafeAPI {
        private UnsafeAPI() {
        }

        public long getNumber() {
            return 7331L;
        }
    }

    public static class ClassWithUnsafeConfiguredComponent {
        @org.neo4j.procedure.Context
        public UnsafeAPI api;

        @Procedure
        public Stream<Output> unsafeFullAccessProcedure() {
            return Stream.of(new Output(this.api.getNumber()));
        }

        @UserFunction
        public long unsafeFullAccessFunction() {
            return this.api.getNumber();
        }
    }

    public static class ClassWithUnsafeComponent {
        @org.neo4j.procedure.Context
        public UnsafeAPI api;

        @Procedure
        public Stream<Output> unsafeProcedure() {
            return Stream.of(new Output(this.api.getNumber()));
        }

        @UserFunction
        public long unsafeFunction() {
            return this.api.getNumber();
        }
    }

    public static class ClassWithGenericStream {
        @Procedure
        public Stream<List<Output>> genericStream() {
            return Stream.of(Collections.singletonList(new Output()));
        }
    }

    public static class ClassWithRawStream {
        @Procedure
        public Stream rawStreamProc() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithWildCardStream {
        @Procedure
        public Stream<?> wildCardProc() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithProcedureWithArgument {
        @Procedure
        public Stream<Output> myProcedure(@Name(value="value") long value) {
            return Stream.of(new Output(value));
        }
    }

    public static class ClassWithAnotherProcedure {
        @Procedure
        public Stream<Output> myOtherProcedure() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithNoProcedureAtAll {
        void thisMethodIsEntirelyUnrelatedToAllThisExcitement() {
        }
    }

    public static class ClassWithOneProcedure {
        @Procedure
        public Stream<Output> myProcedure() {
            return Stream.of(new Output());
        }
    }

    public static class ClassWithInvalidProcedure {
        @Procedure
        public boolean booleansAreNotAcceptableReturnTypes() {
            return false;
        }
    }

    public static class Output {
        public long someNumber = 1337L;

        public Output() {
        }

        public Output(long anotherNumber) {
            this.someNumber = anotherNumber;
        }
    }
}

