/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;

public class UserFunctionSignatureTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final UserFunctionSignature signature = UserFunctionSignature.functionSignature((String[])new String[]{"asd"}).in("in", Neo4jTypes.NTAny).out(Neo4jTypes.NTAny).build();

    @Test
    public void inputSignatureShouldNotBeModifiable() {
        this.exception.expect(UnsupportedOperationException.class);
        this.signature.inputSignature().add(FieldSignature.inputField((String)"in2", (Neo4jTypes.AnyType)Neo4jTypes.NTAny));
    }

    @Test
    public void toStringShouldMatchCypherSyntax() {
        String toStr = UserFunctionSignature.functionSignature((String[])new String[]{"org", "myProcedure"}).in("in", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out((Neo4jTypes.AnyType)Neo4jTypes.NTNumber).build().toString();
        Assert.assertEquals((Object)"org.myProcedure(in :: LIST? OF STRING?) :: (NUMBER?)", (Object)toStr);
    }
}

