/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyCreatorTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    private final MyPrimitiveProxy primitive = new MyPrimitiveProxy();
    private NeoStores neoStores;
    private PropertyStore propertyStore;
    private PropertyCreator creator;
    private DirectRecordAccess<PropertyRecord, PrimitiveRecord> records;

    @Before
    public void startStore() {
        this.neoStores = new StoreFactory(this.storage.directory().databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), this.storage.pageCache(), this.storage.fileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY).openNeoStores(true, new StoreType[]{StoreType.PROPERTY, StoreType.PROPERTY_STRING, StoreType.PROPERTY_ARRAY});
        this.propertyStore = this.neoStores.getPropertyStore();
        this.records = new DirectRecordAccess((RecordStore)this.propertyStore, Loaders.propertyLoader((PropertyStore)this.propertyStore));
        this.creator = new PropertyCreator(this.propertyStore, new PropertyTraverser());
    }

    @After
    public void closeStore() {
        this.neoStores.close();
    }

    @Test
    public void shouldAddPropertyToEmptyChain() {
        this.existingChain(new ExpectedRecord[0]);
        this.setProperty(1, "value");
        this.assertChain(this.record(PropertyCreatorTest.property(1, "value")));
    }

    @Test
    public void shouldAddPropertyToChainContainingOtherFullRecords() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6), PropertyCreatorTest.property(7, 7)));
        this.setProperty(10, 10);
        this.assertChain(this.record(PropertyCreatorTest.property(10, 10)), this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6), PropertyCreatorTest.property(7, 7)));
    }

    @Test
    public void shouldAddPropertyToChainContainingOtherNonFullRecords() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6)));
        this.setProperty(10, 10);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6), PropertyCreatorTest.property(10, 10)));
    }

    @Test
    public void shouldAddPropertyToChainContainingOtherNonFullRecordsInMiddle() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2)), this.record(PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6)));
        this.setProperty(10, 10);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(10, 10)), this.record(PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6)));
    }

    @Test
    public void shouldChangeOnlyProperty() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "one")));
        this.setProperty(0, "two");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "two")));
    }

    @Test
    public void shouldChangePropertyInChainWithOthersBeforeIt() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "one"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two"), PropertyCreatorTest.property(3, 3)));
        this.setProperty(2, "two*");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "one"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two*"), PropertyCreatorTest.property(3, 3)));
    }

    @Test
    public void shouldChangePropertyInChainWithOthersAfterIt() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "one"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two"), PropertyCreatorTest.property(3, 3)));
        this.setProperty(0, "one*");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "one*"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two"), PropertyCreatorTest.property(3, 3)));
    }

    @Test
    public void shouldChangePropertyToBiggerInFullChain() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)));
        this.setProperty(1, Long.MAX_VALUE);
        this.assertChain(this.record(PropertyCreatorTest.property(1, Long.MAX_VALUE)), this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)));
    }

    @Test
    public void shouldChangePropertyToBiggerInChainWithHoleAfter() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5)));
        this.setProperty(1, Long.MAX_VALUE);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(1, Long.MAX_VALUE)));
    }

    @Test
    public void shouldChangePropertyToBiggerInChainWithHoleBefore() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5)));
        this.setProperty(2, Long.MAX_VALUE);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, Long.MAX_VALUE)), this.record(PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5)));
    }

    @Test
    public void canAddMultipleShortStringsToTheSameNode() {
        this.existingChain(new ExpectedRecord[0]);
        this.setProperty(0, "value");
        this.setProperty(1, "esrever");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "value", false), PropertyCreatorTest.property(1, "esrever", false)));
    }

    @Test
    public void canUpdateShortStringInplace() {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "value")));
        long before = this.propertyRecordsInUse();
        this.setProperty(0, "other");
        long after = this.propertyRecordsInUse();
        this.assertChain(this.record(PropertyCreatorTest.property(0, "other")));
        Assert.assertEquals((long)before, (long)after);
    }

    @Test
    public void canReplaceLongStringWithShortString() {
        long recordCount = this.dynamicStringRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        this.existingChain(this.record(PropertyCreatorTest.property(0, "this is a really long string, believe me!")));
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicStringRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        this.setProperty(0, "value");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "value", false)));
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicStringRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
    }

    @Test
    public void canReplaceShortStringWithLongString() {
        long recordCount = this.dynamicStringRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        this.existingChain(this.record(PropertyCreatorTest.property(0, "value")));
        Assert.assertEquals((long)recordCount, (long)this.dynamicStringRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        String longString = "this is a really long string, believe me!";
        this.setProperty(0, longString);
        this.assertChain(this.record(PropertyCreatorTest.property(0, longString, true)));
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicStringRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
    }

    private void existingChain(ExpectedRecord ... initialRecords) {
        PropertyRecord prev = null;
        for (ExpectedRecord initialRecord : initialRecords) {
            PropertyRecord record = (PropertyRecord)this.records.create(this.propertyStore.nextId(), (Object)this.primitive.record).forChangingData();
            record.setInUse(true);
            this.existingRecord(record, initialRecord);
            if (prev == null) {
                this.primitive.record.setNextProp(record.getId());
            } else {
                record.setPrevProp(prev.getId());
                prev.setNextProp(record.getId());
            }
            prev = record;
        }
    }

    private void existingRecord(PropertyRecord record, ExpectedRecord initialRecord) {
        for (ExpectedProperty initialProperty : initialRecord.properties) {
            PropertyBlock block = new PropertyBlock();
            this.propertyStore.encodeValue(block, initialProperty.key, initialProperty.value);
            record.addPropertyBlock(block);
        }
        Assert.assertTrue((record.size() <= PropertyType.getPayloadSize() ? 1 : 0) != 0);
    }

    private void setProperty(int key, Object value) {
        this.creator.primitiveSetProperty((RecordAccess.RecordProxy)this.primitive, key, Values.of((Object)value), this.records);
    }

    private void assertChain(ExpectedRecord ... expectedRecords) {
        long nextProp = this.primitive.forReadingLinkage().getNextProp();
        int expectedRecordCursor = 0;
        while (!Record.NO_NEXT_PROPERTY.is(nextProp)) {
            PropertyRecord record = (PropertyRecord)this.records.getIfLoaded(nextProp).forReadingData();
            this.assertRecord(record, expectedRecords[expectedRecordCursor++]);
            nextProp = record.getNextProp();
        }
    }

    private void assertRecord(PropertyRecord record, ExpectedRecord expectedRecord) {
        Assert.assertEquals((long)expectedRecord.properties.length, (long)record.numberOfProperties());
        for (ExpectedProperty expectedProperty : expectedRecord.properties) {
            PropertyBlock block = record.getPropertyBlock(expectedProperty.key);
            Assert.assertNotNull((Object)block);
            Assert.assertEquals((Object)expectedProperty.value, (Object)block.getType().value(block, this.propertyStore));
            if (expectedProperty.assertHasDynamicRecords == null) continue;
            if (expectedProperty.assertHasDynamicRecords.booleanValue()) {
                Assert.assertThat((Object)block.getValueRecords().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                continue;
            }
            Assert.assertEquals((long)0L, (long)block.getValueRecords().size());
        }
    }

    private static ExpectedProperty property(int key, Object value) {
        return new ExpectedProperty(key, value);
    }

    private static ExpectedProperty property(int key, Object value, boolean hasDynamicRecords) {
        return new ExpectedProperty(key, value, hasDynamicRecords);
    }

    private ExpectedRecord record(ExpectedProperty ... properties) {
        return new ExpectedRecord(properties);
    }

    private long propertyRecordsInUse() {
        return this.propertyStore.getHighId();
    }

    private long dynamicStringRecordsInUse() {
        return this.propertyStore.getStringStore().getHighId();
    }

    private static class MyPrimitiveProxy
    implements RecordAccess.RecordProxy<NodeRecord, Void> {
        private final NodeRecord record = new NodeRecord(5L);
        private boolean changed;

        MyPrimitiveProxy() {
            this.record.setInUse(true);
        }

        public long getKey() {
            return this.record.getId();
        }

        public NodeRecord forChangingLinkage() {
            this.changed = true;
            return this.record;
        }

        public NodeRecord forChangingData() {
            this.changed = true;
            return this.record;
        }

        public NodeRecord forReadingLinkage() {
            return this.record;
        }

        public NodeRecord forReadingData() {
            return this.record;
        }

        public Void getAdditionalData() {
            return null;
        }

        public NodeRecord getBefore() {
            return this.record;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isCreated() {
            return false;
        }
    }

    private static class ExpectedRecord {
        private final ExpectedProperty[] properties;

        ExpectedRecord(ExpectedProperty ... properties) {
            this.properties = properties;
        }
    }

    private static class ExpectedProperty {
        private final int key;
        private final Value value;
        private final Boolean assertHasDynamicRecords;

        ExpectedProperty(int key, Object value) {
            this(key, value, null);
        }

        ExpectedProperty(int key, Object value, Boolean assertHasDynamicRecords) {
            this.key = key;
            this.value = Values.of((Object)value);
            this.assertHasDynamicRecords = assertHasDynamicRecords;
        }
    }
}

