/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordNodeCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordPropertyCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipGroupCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;

class RecordCursorsTest {
    RecordCursorsTest() {
    }

    @Test
    void nodeCursorShouldClosePageCursor() {
        NodeStore store = (NodeStore)Mockito.mock(NodeStore.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)store.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)pageCursor);
        try (RecordNodeCursor cursor = new RecordNodeCursor(store);){
            cursor.single(0L);
        }
        ((PageCursor)Mockito.verify((Object)pageCursor)).close();
    }

    @Test
    void relationshipScanCursorShouldClosePageCursor() {
        RelationshipStore store = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)store.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)pageCursor);
        try (RecordRelationshipScanCursor cursor = new RecordRelationshipScanCursor(store);){
            cursor.single(0L);
        }
        ((PageCursor)Mockito.verify((Object)pageCursor)).close();
    }

    @Test
    void relationshipTraversalCursorShouldClosePageCursor() {
        RelationshipStore store = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)store.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)pageCursor);
        RelationshipGroupStore groupStore = (RelationshipGroupStore)Mockito.mock(RelationshipGroupStore.class);
        PageCursor groupPageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)store.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)pageCursor);
        try (RecordRelationshipTraversalCursor cursor = new RecordRelationshipTraversalCursor(store, groupStore);){
            cursor.init(0L, 0L);
        }
        ((PageCursor)Mockito.verify((Object)pageCursor)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{groupPageCursor, groupStore});
    }

    @Test
    void relationshipGroupCursorShouldClosePageCursor() {
        RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        PageCursor relationshipPageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)relationshipStore.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)relationshipPageCursor);
        RelationshipGroupStore store = (RelationshipGroupStore)Mockito.mock(RelationshipGroupStore.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)store.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)pageCursor);
        try (RecordRelationshipGroupCursor cursor = new RecordRelationshipGroupCursor(relationshipStore, store);){
            cursor.init(0L, 0L);
        }
        ((PageCursor)Mockito.verify((Object)pageCursor)).close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{relationshipStore, relationshipPageCursor});
    }

    @Test
    void propertyCursorShouldClosePageCursor() {
        PropertyStore store = (PropertyStore)Mockito.mock(PropertyStore.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)store.openPageCursorForReading(ArgumentMatchers.anyLong())).thenReturn((Object)pageCursor);
        try (RecordPropertyCursor cursor = new RecordPropertyCursor(store);){
            cursor.init(0L);
        }
        ((PageCursor)Mockito.verify((Object)pageCursor)).close();
    }
}

