/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.impl.block.factory.Functions;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordBuilders;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;

public class RecordMatchers {
    public static DiffMatcher<RecordChangeSet> containsChanges(final AbstractBaseRecord ... expectedChanges) {
        final DiffMatcher<Iterable<? extends AbstractBaseRecord>> nodes = RecordMatchers.containsRecords("nodes", RecordBuilders.filterType(expectedChanges, NodeRecord.class));
        final DiffMatcher<Iterable<? extends AbstractBaseRecord>> rels = RecordMatchers.containsRecords("relationships", RecordBuilders.filterType(expectedChanges, RelationshipRecord.class));
        final DiffMatcher<Iterable<? extends AbstractBaseRecord>> groups = RecordMatchers.containsRecords("relationship groups", RecordBuilders.filterType(expectedChanges, RelationshipGroupRecord.class));
        return new DiffMatcher<RecordChangeSet>(){

            @Override
            String diff(RecordChangeSet actual) {
                String diff = nodes.diff(RecordBuilders.records(actual.getNodeRecords().changes()));
                if (diff != null) {
                    return diff;
                }
                diff = rels.diff(RecordBuilders.records(actual.getRelRecords().changes()));
                if (diff != null) {
                    return diff;
                }
                diff = groups.diff(RecordBuilders.records(actual.getRelGroupRecords().changes()));
                if (diff != null) {
                    return diff;
                }
                return null;
            }

            public void describeTo(Description description) {
                description.appendValueList("[", ",", "]", (Object[])expectedChanges);
            }
        };
    }

    public static DiffMatcher<Iterable<? extends AbstractBaseRecord>> containsRecords(final String recordPlural, Stream<? extends AbstractBaseRecord> expected) {
        final Map expectedById = expected.collect(Collectors.toMap(AbstractBaseRecord::getId, Functions.identity()));
        return new DiffMatcher<Iterable<? extends AbstractBaseRecord>>(){

            @Override
            String diff(Iterable<? extends AbstractBaseRecord> actual) {
                HashSet seen = new HashSet(expectedById.keySet());
                for (AbstractBaseRecord abstractBaseRecord : actual) {
                    seen.remove(abstractBaseRecord.getId());
                    if (!expectedById.containsKey(abstractBaseRecord.getId())) {
                        return String.format("This record was not expected: %s", abstractBaseRecord);
                    }
                    String diff = this.diff((AbstractBaseRecord)expectedById.get(abstractBaseRecord.getId()), abstractBaseRecord);
                    if (diff == null) continue;
                    return diff;
                }
                return null;
            }

            private String diff(AbstractBaseRecord expected, AbstractBaseRecord actual) {
                if (expected instanceof NodeRecord) {
                    return this.diff((NodeRecord)expected, (NodeRecord)actual);
                }
                if (expected instanceof RelationshipRecord) {
                    return this.diff((RelationshipRecord)expected, (RelationshipRecord)actual);
                }
                if (expected instanceof RelationshipGroupRecord) {
                    return this.diff((RelationshipGroupRecord)expected, (RelationshipGroupRecord)actual);
                }
                throw new UnsupportedOperationException(String.format("No diff implementation (just add one, its easy) for: %s", expected));
            }

            private String diff(NodeRecord expected, NodeRecord actual) {
                if (actual.getId() == expected.getId() && actual.getNextRel() == expected.getNextRel() && actual.getLabelField() == expected.getLabelField() && actual.getNextProp() == expected.getNextProp() && actual.isDense() == expected.isDense() && actual.isLight() == expected.isLight()) {
                    return null;
                }
                return this.describeDiff(expected.toString(), actual.toString());
            }

            private String diff(RelationshipGroupRecord expected, RelationshipGroupRecord actual) {
                if (actual.getId() == expected.getId() && actual.getType() == expected.getType() && actual.getNext() == expected.getNext() && actual.getFirstOut() == expected.getFirstOut() && actual.getFirstIn() == expected.getFirstIn() && actual.getFirstLoop() == expected.getFirstLoop() && actual.getOwningNode() == expected.getOwningNode()) {
                    return null;
                }
                return this.describeDiff(expected.toString(), actual.toString());
            }

            private String diff(RelationshipRecord expected, RelationshipRecord actual) {
                if (actual.getId() == expected.getId() && actual.getFirstNode() == expected.getFirstNode() && actual.getSecondNode() == expected.getSecondNode() && actual.getType() == expected.getType() && actual.getFirstPrevRel() == expected.getFirstPrevRel() && actual.getFirstNextRel() == expected.getFirstNextRel() && actual.getSecondPrevRel() == expected.getSecondPrevRel() && actual.getSecondNextRel() == expected.getSecondNextRel() && actual.isFirstInFirstChain() == expected.isFirstInFirstChain() && actual.isFirstInSecondChain() == expected.isFirstInSecondChain()) {
                    return null;
                }
                return this.describeDiff(expected.toString(), actual.toString());
            }

            private String describeDiff(String expected, String actual) {
                StringBuilder arrow = new StringBuilder();
                char[] expectedChars = expected.toCharArray();
                char[] actualChars = actual.toCharArray();
                for (int i = 0; i < Math.min(expectedChars.length, actualChars.length) && expectedChars[i] == actualChars[i]; ++i) {
                    arrow.append("-");
                }
                return String.format("Record fields don't match.\nExpected: %s\nActual:   %s\n          %s", expected, actual, arrow.append("^").toString());
            }

            public void describeTo(Description description) {
                description.appendValueList(String.format("%s matching:\n  ", recordPlural), "\n  ", "", expectedById.values());
            }
        };
    }

    public static abstract class DiffMatcher<T>
    extends TypeSafeMatcher<T> {
        abstract String diff(T var1);

        protected boolean matchesSafely(T item) {
            return this.diff(item) == null;
        }

        protected void describeMismatchSafely(T item, Description mismatchDescription) {
            mismatchDescription.appendText(this.diff(item));
        }
    }
}

