/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class RecordRelationshipScanCursorTest {
    private static final long RELATIONSHIP_ID = 1L;
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule());
    @Rule
    public final RandomRule random = new RandomRule();
    private NeoStores neoStores;

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Before
    public void setUp() {
        StoreFactory storeFactory = this.getStoreFactory();
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @Test
    public void retrieveUsedRelationship() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        this.createRelationshipRecord(1L, 1, relationshipStore, true);
        try (RecordRelationshipScanCursor cursor = this.createRelationshipCursor();){
            cursor.single(1L);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)1L, (long)cursor.entityReference());
        }
    }

    @Test
    public void retrieveUnusedRelationship() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        relationshipStore.setHighId(10L);
        this.createRelationshipRecord(1L, 1, relationshipStore, false);
        try (RecordRelationshipScanCursor cursor = this.createRelationshipCursor();){
            cursor.single(1L);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    public void shouldScanAllInUseRelationships() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        int count = 100;
        relationshipStore.setHighId((long)count);
        HashSet<Long> expected = new HashSet<Long>();
        for (long id = 0L; id < (long)count; ++id) {
            boolean inUse = this.random.nextBoolean();
            this.createRelationshipRecord(id, 1, relationshipStore, inUse);
            if (!inUse) continue;
            expected.add(id);
        }
        this.assertSeesRelationships(expected, -1);
    }

    @Test
    public void shouldScanAllInUseRelationshipsOfCertainType() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        int count = 100;
        relationshipStore.setHighId((long)count);
        HashSet<Long> expected = new HashSet<Long>();
        int theType = 1;
        for (long id = 0L; id < (long)count; ++id) {
            boolean inUse = this.random.nextBoolean();
            int type = this.random.nextInt(3);
            this.createRelationshipRecord(id, type, relationshipStore, inUse);
            if (!inUse || type != theType) continue;
            expected.add(id);
        }
        this.assertSeesRelationships(expected, theType);
    }

    private void assertSeesRelationships(Set<Long> expected, int type) {
        try (RecordRelationshipScanCursor cursor = this.createRelationshipCursor();){
            cursor.scan(type);
            while (cursor.next()) {
                Assert.assertTrue((String)cursor.toString(), (boolean)expected.remove(cursor.entityReference()));
            }
        }
        Assert.assertTrue((boolean)expected.isEmpty());
    }

    private void createRelationshipRecord(long id, int type, RelationshipStore relationshipStore, boolean used) {
        relationshipStore.updateRecord((AbstractBaseRecord)new RelationshipRecord(id).initialize(used, -1L, 1L, 2L, type, -1L, -1L, -1L, -1L, true, true));
    }

    private StoreFactory getStoreFactory() {
        return new StoreFactory(this.storage.directory().databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), this.storage.pageCache(), this.storage.fileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
    }

    private RecordRelationshipScanCursor createRelationshipCursor() {
        return new RecordRelationshipScanCursor(this.neoStores.getRelationshipStore());
    }
}

