/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.MockedNeoStores;

public class RecordStorageReaderTest {
    @Test
    public void shouldCloseOpenedLabelScanReader() {
        Supplier scanStore = (Supplier)Mockito.mock(Supplier.class);
        LabelScanReader scanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
        Mockito.when(scanStore.get()).thenReturn((Object)scanReader);
        RecordStorageReader statement = new RecordStorageReader(null, null, MockedNeoStores.basicMockedNeoStores(), null, null, (Supplier)Mockito.mock(Supplier.class), scanStore, (RecordStorageCommandCreationContext)Mockito.mock(RecordStorageCommandCreationContext.class));
        statement.acquire();
        LabelScanReader actualReader = statement.getLabelScanReader();
        Assert.assertEquals((Object)scanReader, (Object)actualReader);
        statement.close();
        ((Supplier)Mockito.verify((Object)scanStore)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{scanStore});
        ((LabelScanReader)Mockito.verify((Object)scanReader)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{scanReader});
    }
}

