/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestIdGeneratorRebuilding {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    private EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule.get());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.testDirectory);
    private EphemeralFileSystemAbstraction fs;

    @Before
    public void doBefore() {
        this.fs = (EphemeralFileSystemAbstraction)this.fsRule.get();
    }

    @Test
    public void verifyFixedSizeStoresCanRebuildIdGeneratorSlowly() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.rebuild_idgenerators_fast, (String)"false");
        File storeFile = this.testDirectory.file("nodes");
        File idFile = this.testDirectory.file("idNodes");
        DynamicArrayStore labelStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
        NodeStore store = new NodeStore(storeFile, idFile, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (LogProvider)NullLogProvider.getInstance(), labelStore, RecordFormatSelector.defaultFormat(), new OpenOption[0]);
        store.initialise(true);
        store.makeStoreOk();
        NodeRecord record = new NodeRecord(0L);
        record.setInUse(true);
        int highestId = 50;
        for (int i = 0; i < highestId; ++i) {
            Assert.assertThat((Object)store.nextId(), (Matcher)Matchers.is((Object)i));
            record.setId((long)i);
            store.updateRecord(record);
        }
        store.setHighestPossibleIdInUse((long)highestId);
        Long[] idsToFree = new Long[]{2L, 3L, 5L, 7L};
        record.setInUse(false);
        Long[] longArray = idsToFree;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long toDelete = longArray[i];
            record.setId(toDelete);
            store.updateRecord(record);
        }
        store.rebuildIdGenerator();
        store.closeIdGenerator();
        store.openIdGenerator();
        ArrayList<Long> nextIds = new ArrayList<Long>();
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        Assert.assertThat(nextIds, (Matcher)Matchers.contains((Object[])new Long[]{2L, 3L, 5L, 7L, 50L}));
        store.close();
    }

    @Test
    public void verifyDynamicSizedStoresCanRebuildIdGeneratorSlowly() throws Exception {
        Long[] sb;
        Config config = Config.defaults((Setting)GraphDatabaseSettings.rebuild_idgenerators_fast, (String)"false");
        StoreFactory storeFactory = new StoreFactory(this.testDirectory.databaseLayout(), config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (FileSystemAbstraction)this.fs, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = storeFactory.openAllNeoStores(true);
        DynamicStringStore store = neoStores.getPropertyStore().getStringStore();
        DynamicRecord record = new DynamicRecord(1L);
        record.setInUse(true, PropertyType.STRING.intValue());
        int highestId = 50;
        for (int i = 1; i <= highestId; ++i) {
            Assert.assertThat((Object)store.nextId(), (Matcher)Matchers.is((Object)i));
            record.setId((long)i);
            sb = new StringBuilder(i);
            for (int j = 0; j < i; ++j) {
                sb.append('a');
            }
            record.setData(sb.toString().getBytes(StandardCharsets.UTF_16));
            store.updateRecord((AbstractBaseRecord)record);
        }
        store.setHighestPossibleIdInUse((long)highestId);
        Long[] idsToFree = new Long[]{2L, 3L, 5L, 7L};
        record.setInUse(false);
        sb = idsToFree;
        int n = sb.length;
        for (int i = 0; i < n; ++i) {
            long toDelete = sb[i];
            record.setId(toDelete);
            store.updateRecord((AbstractBaseRecord)record);
        }
        store.rebuildIdGenerator();
        ArrayList<Long> nextIds = new ArrayList<Long>();
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        Assert.assertThat(nextIds, (Matcher)Matchers.contains((Object[])new Long[]{2L, 3L, 5L, 7L, 51L}));
        neoStores.close();
    }

    @Test
    public void rebuildingIdGeneratorMustNotMissOutOnFreeRecordsAtEndOfFilePage() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.rebuild_idgenerators_fast, (String)"false");
        File storeFile = this.testDirectory.file("nodes");
        File idFile = this.testDirectory.file("idNodes");
        DynamicArrayStore labelStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
        NodeStore store = new NodeStore(storeFile, idFile, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (LogProvider)NullLogProvider.getInstance(), labelStore, RecordFormatSelector.defaultFormat(), new OpenOption[0]);
        store.initialise(true);
        store.makeStoreOk();
        int recordsPerPage = store.getRecordsPerPage();
        NodeRecord record = new NodeRecord(0L);
        record.setInUse(true);
        int highestId = recordsPerPage * 3;
        for (int i = 0; i < highestId; ++i) {
            Assert.assertThat((Object)store.nextId(), (Matcher)Matchers.is((Object)i));
            record.setId((long)i);
            store.updateRecord(record);
        }
        store.setHighestPossibleIdInUse((long)highestId);
        Long[] idsToFree = new Long[]{(long)recordsPerPage - 2L, (long)recordsPerPage - 1L};
        record.setInUse(false);
        Long[] longArray = idsToFree;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long toDelete = longArray[i];
            record.setId(toDelete);
            store.updateRecord(record);
        }
        store.rebuildIdGenerator();
        store.closeIdGenerator();
        store.openIdGenerator();
        ArrayList<Long> nextIds = new ArrayList<Long>();
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        Assert.assertThat(nextIds, (Matcher)Matchers.contains((Object[])new Long[]{(long)recordsPerPage - 2L, (long)recordsPerPage - 1L, (long)recordsPerPage * 3L}));
        store.close();
    }
}

